package com.biz.crm.kms.admin.web.reports.service.internal;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.admin.web.reports.dto.DirectTreeDto;
import com.biz.crm.kms.admin.web.reports.repository.DirectTreeVoRepository;
import com.biz.crm.kms.admin.web.reports.service.DirectTreeVoService;
import com.biz.crm.kms.admin.web.reports.vo.DirectTreeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 系统树状结构数据voService实现类
 *
 * @author songjingen
 * @date 2022/9/27
 */
@Service
public class DirectTreeVoServiceImpl implements DirectTreeVoService {

    @Autowired
    private DirectTreeVoRepository directTreeVoRepository;

    @Override
    public List<DirectTreeVo> findByDirectTreeDto(DirectTreeDto dto) {
        if (dto == null) {
            dto = new DirectTreeDto();
        }
        if (StringUtils.isBlank(dto.getEnableStatus())) {
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<DirectTreeVo> byDirectTreeList = this.directTreeVoRepository.findByDirectTreeDto(dto);
        if (!CollectionUtils.isEmpty(byDirectTreeList)) {
            byDirectTreeList.forEach(directTreeVo -> {
                String directCode = directTreeVo.getDirectCode();
                if (StringUtils.isNotBlank(directCode)) {
                        directTreeVo.setDirectCodeAndName(directCode.concat("-").concat(directTreeVo.getSupermarketName()));
                    }
            });
        }
        return byDirectTreeList;
    }
}
