package com.biz.crm.kms.admin.web.reports.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 集合匹配绑定单据报表
 *
 * @author songjingen
 * @date 2022/11/2 18:04
 */
@Data
@ApiModel(value = "AuditMatchInvoiceReportVo", description = "集合匹配绑定单据报表")
public class AuditMatchInvoiceReportVo extends UuidVo {

  /**
   * 单据类型
   *
   * @see InvoiceTypeRegister#type()
   */
  @ApiModelProperty("单据类型")
  private String invoiceType;

  /**
   * 企业单据编码
   */
  @ApiModelProperty("企业单据编码")
  private String orderNumber;

  /**
   * 商超单据编码
   */
  @ApiModelProperty("商超单据编码")
  private String kaOrderNumber;

  /**
   * 企业产品编号
   */
  @ApiModelProperty("企业产品编号")
  private String goodsCode;

  /**
   * 企业产品名称
   */
  @ApiModelProperty("企业产品名称")
  private String goodsName;

  /**
   * 单据数量
   */
  @ApiModelProperty("单据数量")
  private BigDecimal invoiceCount;

  /**
   * 单据金额
   */
  @ApiModelProperty("单据金额")
  private BigDecimal invoiceAmount;

  /**
   * 单据金额（不含税）
   */
  @ApiModelProperty("单据金额（不含税）")
  private BigDecimal invoiceAmountTaxExclusive;
}
