package com.biz.crm.kms.admin.web.reports.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 直营门店报表数据vo
 *
 * @author ning.zhang
 * @date 2022/9/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "DirectStoreReportVo", description = "直营门店报表数据vo")
public class DirectStoreReportVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 1284939743641258621L;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 系统名称
   */
  @ApiModelProperty("系统名称")
  private String directName;

  /**
   * 企业门店编码
   */
  @ApiModelProperty("企业门店编码")
  private String terminalCode;

  /**
   * 企业门店名称
   */
  @ApiModelProperty("企业门店名称")
  private String terminalName;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 商超门店编码
   */
  @ApiModelProperty("商超门店编码")
  private String supermarketStoreCode;

  /**
   * 商超门店名称
   */
  @ApiModelProperty("商超门店名称")
  private String supermarketStoreName;

  /**
   * 对账时间阈值
   */
  @ApiModelProperty("对账时间阈值")
  private Integer timeThreshold;
}
