package com.biz.crm.kms.admin.web.reports.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 系统树结构数据vo
 *
 * @author songjingen
 * @date 2022/9/27
 */
@Data
public class DirectTreeVo extends UuidVo {

  private static final long serialVersionUID = -2856001390549926667L;
  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;
  /**
   * 系统编码+名称
   */
  @ApiModelProperty("系统编码+名称")
  private String directCodeAndName;
  /**
   * 系统名称（关联商超名称）
   */
  @ApiModelProperty("系统名称（关联商超名称）")
  private String supermarketName;

  /**
   * 启禁用状态
   */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /**
   * 商超单据类型
   *
   * @see InvoiceTypeRegister#type()
   */
  @ApiModelProperty("商超单据类型，字符串数组")
  private String invoiceType;

  /**
   * 业务单元
   */
  @ApiModelProperty("业务单元")
  private String businessUnitCode;

  /**
   * 业态
   */
  @ApiModelProperty("业态")
  private String businessFormatCode;

  /**
   * 销售组织
   */
  @ApiModelProperty("销售组织")
  private String salesOrgCode;

}
