package com.biz.crm.kms.admin.web.reports.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商超门店报表Vo
 *
 * @author ning.zhang
 * @date 2022/10/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SupermarketStoreReportVo", description = "商超门店报表Vo")
public class SupermarketStoreReportVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 5841086530453186194L;

  /**
   * 门店编码
   */
  @ApiModelProperty("门店编码")
  private String storeCode;

  /**
   * 门店名称
   */
  @ApiModelProperty("门店名称")
  private String storeName;

  /**
   * 关联商超编码
   */
  @ApiModelProperty("关联商超编码")
  private String supermarketCode;

  /**
   * 关联商超名称
   */
  @ApiModelProperty("关联商超名称")
  private String supermarketName;

  /**
   * 关联商超区域编码
   */
  @ApiModelProperty("关联商超区域编码")
  private String supermarketAreaCode;

  /**
   * 关联商超区域名称
   */
  @ApiModelProperty("关联商超区域名称")
  private String supermarketAreaName;
}
