package com.biz.crm.kms.business.account.receivable.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.account.receivable.local.entity.AccountReceivableEntity;
import com.biz.crm.kms.business.account.receivable.local.service.AccountReceivableService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * (AccountReceivable)表相关的http接口
 *
 * @author cyj
 * @since 2022-11-25 17:05:25
 */
@RestController
@RequestMapping("/v1/accountReceivable/accountReceivable")
@Slf4j
@Api(tags = "应收台账")
public class AccountReceivableController {
  /**
  * 服务对象
  */
  @Autowired
  private AccountReceivableService accountReceivableService;
  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AccountReceivableEntity> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AccountReceivableEntity stock = this.accountReceivableService.findById(id);
      return Result.ok(stock);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  /**
   * 同步对账单数据
   */
  @ApiOperation(value = "同步对账单数据")
  @PostMapping("synchronize")
  public Result<?> synchronize() {
    try {
      this.accountReceivableService.synchronize();
      return Result.ok("同步成功！");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
