package com.biz.crm.kms.business.account.receivable.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "accountReceivableEntity", description = "应收台账实体")
@Entity
@TableName("kms_account_receivable")
@Table(name = "kms_account_receivable" ,indexes = {
        @Index(name = "kms_account_receivable_index1", columnList = "id", unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "kms_account_receivable", comment = "应收台账数据表单")
public class  AccountReceivableEntity extends TenantFlagOpEntity {

    /**
     * 时间(yyyy.MM)
     */
    @ApiModelProperty(name = "时间(yyyy.MM)", notes = "")
    @Column(name = "account_date", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '时间(yyyy.MM)'")
    private String accountDate;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 64, columnDefinition = "varchar(64) COMMENT '系统编码'")
    private String directCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统名称")
    @Column(name = "direct_name", length = 128, columnDefinition = "varchar(128) COMMENT '系统名称'")
    private String directName;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "")
    @Column(name = "customer_retailer_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "")
    @Column(name = "customer_retailer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '零售商名称'")
    private String customerRetailerName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    @ApiModelProperty("售达方编码")
    @Column(name = "sell_party_code", length = 64, columnDefinition = "varchar(32) COMMENT '售达方编码'")
    private String sellPartyCode;

    @ApiModelProperty("售达方名称")
    @Column(name = "sell_party_name", length = 64, columnDefinition = "varchar(32) COMMENT '售达方名称'")
    private String sellPartyName;

    /**
     * SAP期末应收余额
     */
    @ApiModelProperty("SAP期末应收余额")
    @Column(name = "sap_last_receivable", columnDefinition = "decimal(20,4) COMMENT 'SAP期末应收余额'")
    private BigDecimal sapLastReceivable;

    /**
     * 总计应收
     */
    @ApiModelProperty("总计应收")
    @Column(name = "total_receivable", columnDefinition = "decimal(20,4) COMMENT '总计应收'")
    private BigDecimal TotalReceivable;

    /**
     * 未对账金额
     */
    @ApiModelProperty("未对账金额")
    @Column(name = "unreconciled_amount", columnDefinition = "decimal(20,4) COMMENT '未对账金额'")
    private BigDecimal unreconciledAmount;

    /**
     * 对账金额
     */
    @ApiModelProperty("对账金额")
    @Column(name = "reconciled_amount", columnDefinition = "decimal(20,4) COMMENT '对账金额'")
    private BigDecimal reconciledAmount;

    /**
     * 验收金额
     */
    @ApiModelProperty("验收金额")
    @Column(name = "acceptance_amount", columnDefinition = "decimal(20,4) COMMENT '验收金额'")
    private BigDecimal acceptanceAmount;

    /**
     * 验收金额
     */
    @ApiModelProperty("退货金额")
    @Column(name = "return_amount", columnDefinition = "decimal(20,4) COMMENT '退货金额'")
    private BigDecimal returnAmount;

    /**
     * 零售商退货金额
     */
    @ApiModelProperty("零售商退货金额")
    @Column(name = "retailer_amount", columnDefinition = "decimal(20,4) COMMENT '零售商退货金额'")
    private BigDecimal retailerAmount;

    /**
     * 价差费用
     */
    @ApiModelProperty("价差费用")
    @Column(name = "price_differ_amount", columnDefinition = "decimal(20,4) COMMENT '价差费用'")
    private BigDecimal priceDifferAmount;

    /**
     * 票扣费用
     */
    @ApiModelProperty("票扣费用")
    @Column(name = "ticket_deduction_amount", columnDefinition = "decimal(20,4) COMMENT '票扣费用'")
    private BigDecimal ticketDeductionAmount;

    /**
     * 账扣费用
     */
    @ApiModelProperty("账扣费用")
    @Column(name = "account_deduction_amount", columnDefinition = "decimal(20,4) COMMENT '账扣费用'")
    private BigDecimal accountDeductionAmount;

    /**
     * 实际上账费用
     */
    @ApiModelProperty("实际上账费用")
    @Column(name = "actual_post_amount", columnDefinition = "decimal(20,4) COMMENT '实际上账费用'")
    private BigDecimal actualPostAmount;


    /**
     * 差异费用
     */
    @ApiModelProperty("差异费用")
    @Column(name = "differ_fee", columnDefinition = "decimal(20,4) COMMENT '差异费用'")
    private BigDecimal differFee;

    /**
     * 应回款
     */
    @ApiModelProperty("应回款")
    @Column(name = "back_amount", columnDefinition = "decimal(20,4) COMMENT '应回款'")
    private BigDecimal backAmount;

    /**
     * 实际回款
     */
    @ApiModelProperty("实际回款")
    @Column(name = "actual_back_amount", columnDefinition = "decimal(20,4) COMMENT '实际回款'")
    private BigDecimal actualBackAmount;

    /**
     * 报销金额
     */
    @ApiModelProperty("报销金额")
    @Column(name = "reimbursement_amount", columnDefinition = "decimal(20,4) COMMENT '报销金额'")
    private BigDecimal reimbursementAmount;

    /**
     * 差异金额
     */
    @ApiModelProperty("差异金额")
    @Column(name = "differ_amount", columnDefinition = "decimal(20,4) COMMENT '差异金额'")
    private BigDecimal differAmount;

    /**
     * 累计未回款
     */
    @ApiModelProperty("累计未回款")
    @Column(name = "total_unback_amount", columnDefinition = "decimal(20,4) COMMENT '累计未回款'")
    private BigDecimal totalUnbackAmount;

    /**
     * 预核销金额
     */
    @ApiModelProperty("预核销金额")
    @Column(name = "advance_audit_amount", columnDefinition = "decimal(20,4) COMMENT '预核销金额'")
    private BigDecimal advanceAuditAmount;

    /**
     * 费用池余额
     */
    @ApiModelProperty("费用池余额")
    @Column(name = "fee_pool_balance", columnDefinition = "decimal(20,4) COMMENT '费用池余额'")
    private BigDecimal feePoolBalance;


}


