package com.biz.crm.kms.business.account.receivable.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.account.receivable.local.entity.AccountReceivableEntity;
import com.biz.crm.kms.business.account.receivable.local.repository.AccountReceivableRepository;
import com.biz.crm.kms.business.account.receivable.local.service.AccountReceivableService;
import com.biz.crm.kms.business.account.receivable.local.service.AccountReceivableTransService;
import com.biz.crm.kms.business.account.receivable.sdk.constant.AccountReceivableConstant;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchResultEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchStatusEnum;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditMatchVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditMatchVo;
import com.biz.crm.kms.business.financial.auditing.sdk.service.AuditService;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.AuditVo;
import com.biz.crm.kms.business.reconciliation.manage.sdk.constant.ReconciliationConstant;
import com.biz.crm.kms.business.reconciliation.manage.sdk.dto.ReconciliationDto;
import com.biz.crm.kms.business.reconciliation.manage.sdk.service.ReconciliationService;
import com.biz.crm.kms.business.reconciliation.manage.sdk.vo.ReconciliationVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant.KMS_AUDIT_SAP_LOOP_MAX;

/**
 * (accountReceivableServiceImpl)表服务实现类
 *
 * @author cyj
 * @since 2022-11-25 17:05:26
 */
@Service("accountReceivableService")
public class AccountReceivableServiceImpl implements AccountReceivableService {

    @Autowired(required = false)
    private AccountReceivableRepository accountReceivableRepository;
    @Autowired(required = false)
    private ReconciliationService reconciliationService;
    @Autowired(required = false)
    private AccountReceivableTransService accountReceivableTransService;
    @Autowired(required = false)
    private RedisMutexService redisMutexService;

    @Autowired(required = false)
    private AuditService auditService;

    @Autowired(required = false)
    private AuditMatchVoService auditMatchVoService;

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public AccountReceivableEntity findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        return this.accountReceivableRepository.getById(id);
    }

    /**
     * 同步对账单数据
     */
    @Override
    public void synchronize() {
        boolean lock = true;
        String lockKey = DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            String beginDate = DateUtil.format(DateUtil.getFirstDayOfLastMonth(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
            String endDate = DateUtil.format(DateUtil.getLastDayOfLastMonth(),DateUtil.DEFAULT_YEAR_MONTH_DAY);
            ReconciliationDto dto = new ReconciliationDto();
            dto.setBeginDate(beginDate);
            dto.setEndDate(endDate);
            //查询上个月对账数据
            List<ReconciliationVo> list = new ArrayList<>();
            Pageable pageable = PageRequest.of(1, AccountReceivableConstant.DEFAULT_SIZE);
            Page<ReconciliationVo> reconciliationPage = this.reconciliationService.findByConditions(pageable, dto);
            list.addAll(reconciliationPage.getRecords());
            while (reconciliationPage.hasNext()
                    && AccountReceivableConstant.DEFAULT_SIZE >= pageable.getPageNumber()) {
                pageable = pageable.next();
                reconciliationPage = this.reconciliationService.findByConditions(pageable, dto);
                list.addAll(reconciliationPage.getRecords());
            }
            if (CollectionUtils.isEmpty(list)){
                return;
            }
            List<String> soldPartyCodes = list.stream().map(ReconciliationVo::getSoldToPartyCode).distinct().collect(Collectors.toList());
            //查询上月稽核核定数据
            Pageable auditPageable = PageRequest.of(1,1000);
            Page<AuditVo> auditMatchByPage = this.auditService.findAuditByPage(auditPageable, soldPartyCodes, beginDate, endDate);
            List<AuditVo> auditVoList = new ArrayList<>();
            auditVoList.addAll(auditMatchByPage.getRecords());
            while (auditMatchByPage.hasNext()
                    && 2000 >= auditPageable.getPageNumber()) {
                auditPageable = auditPageable.next();
                auditMatchByPage = this.auditService.findAuditByPage(auditPageable, soldPartyCodes, beginDate, endDate);
                auditVoList.addAll(auditMatchByPage.getRecords());
            }
            Map<String,List<AuditVo>> auditVoMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(auditVoList)){
                auditVoMap = auditVoList.stream().distinct().collect(Collectors.groupingBy(AuditVo::getSoldToPartyCode));
            }
            //查询上月稽核单数据
            Pageable auditMatchPageable = PageRequest.of(1,1000);
            List<AuditMatchVo> auditMatchList = new ArrayList<>();
            AuditMatchDto auditMatchDto = new AuditMatchDto();
            auditMatchDto.setTenantCode(TenantUtils.getTenantCode());
            auditMatchDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditMatchDto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            List<String> matchStatus = new ArrayList<>();
            matchStatus.add(MatchStatusEnum.M100.getDictCode());
            matchStatus.add(MatchStatusEnum.M200.getDictCode());
            auditMatchDto.setMatchStatusList(Lists.newArrayList());
            Page<AuditMatchVo> auditMatchPage = this.auditMatchVoService.findAuditMatchPageByConditions(auditMatchPageable,auditMatchDto);
            auditMatchList.addAll(auditMatchPage.getRecords());
            while (auditMatchPage.hasNext()
                    && KMS_AUDIT_SAP_LOOP_MAX >= auditMatchPageable.getPageNumber()) {
                auditMatchPageable = auditMatchPageable.next();
                auditMatchPage = this.auditMatchVoService.findAuditMatchPageByConditions(auditMatchPageable, auditMatchDto);
                auditMatchList.addAll(auditMatchPage.getRecords());
            }
            Map<String,List<AuditMatchVo>> auditMatchVoMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(auditMatchList)){
                auditMatchVoMap = auditMatchList.stream().collect(Collectors.groupingBy(AuditMatchVo::getSoldToPartyCode));
            }

            Map<String, List<ReconciliationVo>> ReconciliationVoMap = list.stream().collect(Collectors.groupingBy(ReconciliationVo::getSoldToPartyCode));
            //组装数据
            List<AccountReceivableEntity> receivableEntityList = new ArrayList<>();
            for (String key : ReconciliationVoMap.keySet()) {
                List<ReconciliationVo> reconciliationVoList = ReconciliationVoMap.get(key);
                ReconciliationVo reconciliationVo =  reconciliationVoList.get(0);
                AccountReceivableEntity receivableEntity = new AccountReceivableEntity();
                receivableEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                receivableEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                receivableEntity.setTenantCode(TenantUtils.getTenantCode());
                receivableEntity.setDirectCode(reconciliationVo.getDirectCode());
                receivableEntity.setDirectName(reconciliationVo.getKaName());
                receivableEntity.setAccountDate(reconciliationVo.getReconciliationDate());
                receivableEntity.setCustomerRetailerCode(reconciliationVo.getKaCode());
                receivableEntity.setCustomerRetailerName(reconciliationVo.getKaName());
                receivableEntity.setBusinessFormatCode(reconciliationVo.getBusinessFormatCode());
                receivableEntity.setBusinessUnitCode(reconciliationVo.getBusinessUnitCode());
                receivableEntity.setSellPartyCode(reconciliationVo.getSoldToPartyCode());
                receivableEntity.setSellPartyName(reconciliationVo.getSoldToPartyName());
                // SAP期末应收余额
                receivableEntity.setSapLastReceivable(BigDecimal.ZERO);
                // 未对账金额
                List<AuditMatchVo> auditMatchVoList = auditMatchVoMap.get(receivableEntity.getSellPartyCode());
                if (!CollectionUtils.isEmpty(auditMatchVoList)){
                    BigDecimal amount = BigDecimal.ZERO;
                    for (AuditMatchVo auditMatchVo : auditMatchVoList) {
                        amount = amount.add(auditMatchVo.getSapTotalAmount());
                    }
                    receivableEntity.setUnreconciledAmount(amount);
                }else {
                    receivableEntity.setUnreconciledAmount(BigDecimal.ZERO);
                }
                //对账金额
                List<AuditVo> auditVos = auditVoMap.get(receivableEntity.getSellPartyCode());
                if (!CollectionUtils.isEmpty(auditVos)){
                    BigDecimal amount = BigDecimal.ZERO;
                    for (AuditVo auditVo : auditVos) {
                        amount = amount.add(auditVo.getSapTotalAmount());
                        receivableEntity.setReconciledAmount(amount);
                    }
                }else {
                    receivableEntity.setReconciledAmount(BigDecimal.ZERO);
                }
                // TODO: 2023/2/28 验收金额,退货金额,实际上账,预核销
                receivableEntity.setAcceptanceAmount(BigDecimal.ZERO);
                receivableEntity.setReturnAmount(BigDecimal.ZERO);
                receivableEntity.setActualPostAmount(BigDecimal.ZERO);
                receivableEntity.setAdvanceAuditAmount(BigDecimal.ZERO);
                //价差费用
                receivableEntity.setPriceDifferAmount(receivableEntity.getReconciledAmount().subtract(receivableEntity.getAcceptanceAmount()).subtract(receivableEntity.getReturnAmount()));

                //票扣和账扣
                BigDecimal ticketAmount = BigDecimal.ZERO;
                BigDecimal accountAmount = BigDecimal.ZERO;
                BigDecimal backAmount = BigDecimal.ZERO;
                BigDecimal actualBackAmount = BigDecimal.ZERO;
                BigDecimal reimbursementAmount = BigDecimal.ZERO;
                for (ReconciliationVo vo : reconciliationVoList) {
                    ticketAmount = ticketAmount.add(vo.getTicketDeductionAmount());
                    accountAmount = accountAmount.add(vo.getAccountDeductionAmount());
                    backAmount = backAmount.add(vo.getAllTicketAmount());
                    actualBackAmount = actualBackAmount.add(vo.getActualReturn());
                    reimbursementAmount = reimbursementAmount.add(vo.getReimbursementAmount());
                }
                receivableEntity.setTicketDeductionAmount(ticketAmount);
                receivableEntity.setAccountDeductionAmount(accountAmount);

                //差异费用
                receivableEntity.setDifferFee(receivableEntity.getAdvanceAuditAmount().subtract(receivableEntity.getActualPostAmount()));

                //应回款
                receivableEntity.setBackAmount(backAmount);

                //实际回款
                receivableEntity.setActualBackAmount(actualBackAmount);

                //报销金额
                receivableEntity.setReimbursementAmount(reimbursementAmount);

                //累计未回款
                receivableEntity.setTotalUnbackAmount(backAmount.subtract(actualBackAmount));

            }

//            while (true) {
//                if (CollectionUtils.isEmpty(list)) {
//                    break;
//                }
//                List<AccountReceivableEntity> receivableEntityList = new ArrayList<>();
//                list.forEach(reconciliationVo -> {
//                    AccountReceivableEntity receivableEntity = new AccountReceivableEntity();
//                    receivableEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
//                    receivableEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//                    receivableEntity.setTenantCode(TenantUtils.getTenantCode());
//                    receivableEntity.setDirectCode(reconciliationVo.getDirectCode());
//                    receivableEntity.setDirectName(reconciliationVo.getKaName());
//                    receivableEntity.setAccountDate(reconciliationVo.getReconciliationDate());
//                    receivableEntity.setCustomerRetailerCode(reconciliationVo.getKaCode());
//                    receivableEntity.setCustomerRetailerName(reconciliationVo.getKaName());
//                    receivableEntity.setBusinessFormatCode(reconciliationVo.getBusinessFormatCode());
//                    receivableEntity.setBusinessUnitCode(reconciliationVo.getBusinessUnitCode());
//                    receivableEntity.setSellPartyCode(reconciliationVo.getSoldToPartyCode());
//                    receivableEntity.setSellPartyName(reconciliationVo.getSoldToPartyName());
//                    receivableEntity.setRemark(reconciliationVo.getRemark());
//                    // SAP期末应收余额
////                receivableEntity.setSapLastReceivable(BigDecimal sapLastReceivable)
//                    // 总计应收
////                receivableEntity.setTotalReceivable(BigDecimal totalReceivable)
//                    // 未对账金额
//                    receivableEntity.setUnreconciledAmount(reconciliationVo.getDifferAmount());
//                    receivableEntity.setReconciledAmount(reconciliationVo.getReconciledAmount());
//                    // 验收金额
////                receivableEntity.setAcceptanceAmount(BigDecimal acceptanceAmount)
//                    // 零售商退货金额
////                receivableEntity.setRetailerAmount();
//                    // 价差费用 = 对账金额-验收金额
////                receivableEntity.setPriceDifferAmount(BigDecimal priceDifferAmount)
//                    receivableEntity.setTicketDeductionAmount(reconciliationVo.getTicketDeductionAmount());
//                    receivableEntity.setAccountDeductionAmount(reconciliationVo.getAccountDeductionAmount());
//                    // 实际上账费用
////                receivableEntity.setActualPostAmount(BigDecimal actualPostAmount)
//                    // 差异费用=票扣费用-实际上账费用
////                receivableEntity.setDifferFee(BigDecimal differFee)
//                    // 应回款= 验收金额-票扣费用
////                receivableEntity.setBackAmount(BigDecimal backAmount)
//                    receivableEntity.setActualBackAmount(reconciliationVo.getActualReturn());
//                    receivableEntity.setReimbursementAmount(reconciliationVo.getReimbursementAmount());
//                    // 差异金额= 应回款金额-实际回款金额
////                receivableEntity.setDifferAmount(BigDecimal differAmount)
//                    // 累计未回款
//                receivableEntity.setTotalUnbackAmount(reconciliationVo.getDifferFee());
//                    // 预核销金额
////                receivableEntity.setAdvanceAuditAmount(BigDecimal advanceAuditAmount)
//                    // 费用池余额
////                receivableEntity.setFeePoolBalance(BigDecimal feePoolBalance)
//                    receivableEntityList.add(receivableEntity);
//                });
//                accountReceivableTransService.saveDataList(receivableEntityList);
//            }
        } finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    /**
     * 释放锁
     *
     * @param lockKey
     */
    private void unLock(String lockKey) {
        if (StringUtils.isEmpty(lockKey)) {
            throw new RuntimeException("拉取库存数据解锁失败，日期不能为空！");
        }
        redisMutexService.unlock(AccountReceivableConstant.ACCOUNT_RECEIVABLE_REPORT_LOCK + lockKey);
    }

    /**
     * 获取锁
     *
     * @param lockKey
     * @return
     */
    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty(lockKey)) {
            throw new RuntimeException("拉取库存数据加锁失败，日期不能为空！");
        }
        return this.redisMutexService.tryLock(AccountReceivableConstant.ACCOUNT_RECEIVABLE_REPORT_LOCK + lockKey, TimeUnit.HOURS, 12);
    }
}

