package com.biz.crm.kms.business.account.receivable.local.service.internal;

import com.biz.crm.kms.business.account.receivable.local.entity.AccountReceivableEntity;
import com.biz.crm.kms.business.account.receivable.local.repository.AccountReceivableRepository;
import com.biz.crm.kms.business.account.receivable.local.service.AccountReceivableTransService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
@Service("accountReceivableTransService")
public class AccountReceivableTransServiceImpl implements AccountReceivableTransService {

    @Autowired(required = false)
    private AccountReceivableRepository accountReceivableRepository;
    /**
     * 批量保存
     *
     * @param saveList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDataList(List<AccountReceivableEntity> saveList) {
        accountReceivableRepository.saveBatch(saveList);
    }
    /**
     * 批量更新
     *
     * @param updateList
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateDataList(List<AccountReceivableEntity> updateList) {
        return accountReceivableRepository.updateBatchById(updateList);
    }
}
