package com.biz.crm.kms.business.audit.match.feign.feign;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.feign.feign.internal.AuditMatchVoFeignImpl;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapConditionDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 *
 * @author hd
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-kms}",
        path = "crm-kms",
        fallbackFactory = AuditMatchVoFeignImpl.class)
public interface AuditMatchVoFeign {

    /**
     * 条件查询数据
     *
     * @param dto
     * @return
     */
    @ApiOperation("条件查询参数")
    @PostMapping("/v1/auditSap/auditSapVo/findByCondition")
    Result<List<AuditSapVo>> findByCondition(@RequestBody AuditSapConditionDto dto);

    @ApiOperation(value = "折扣率变量剩余费用池余额")
    @PostMapping("/v1/auditSap/auditSapVo/surplusFeePoolBalance")
    Result<List<SurplusFeePoolBalanceAuditMatchVo>> surplusFeePoolBalance(@ApiParam(name = "dto", value = "查询条件对象") @RequestBody SurplusFeePoolBalanceAuditMatchDto dto);
}
