package com.biz.crm.kms.business.audit.match.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.feign.feign.AuditMatchVoFeign;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapConditionDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description
 * @Author : hd
 */
@Component
public class AuditMatchVoFeignImpl implements FallbackFactory<AuditMatchVoFeign> {


    @Override
    public AuditMatchVoFeign create(Throwable cause) {
        return new AuditMatchVoFeign() {
            @Override
            public Result<List<AuditSapVo>> findByCondition(AuditSapConditionDto dto) {
                throw new UnsupportedOperationException("条件查询参数关系熔断");
            }

            @Override
            public Result<List<SurplusFeePoolBalanceAuditMatchVo>> surplusFeePoolBalance(SurplusFeePoolBalanceAuditMatchDto dto) {
                throw new UnsupportedOperationException("折扣率变量剩余费用池余额熔断");
            }
        };
    }
}
