package com.biz.crm.kms.business.audit.match.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.feign.feign.AuditMatchVoFeign;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapConditionDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;


/**
 * @Class InvoiceSalesDataVoServiceImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/16  10:56
 */
@Service
@Slf4j
public class AuditSapVoServiceImpl implements AuditSapVoService {

    @Autowired
    private AuditMatchVoFeign auditMatchVoFeign;


    @Override
    public Page<AuditSapVo> findAuditSapVoByConditions(Pageable pageable, AuditSapDto auditSapDto) {
        return null;
    }

    @Override
    public List<AuditSapVo> findByCondition(AuditSapConditionDto dto) {
        if (ObjectUtils.isEmpty(dto)){
            return new ArrayList<>();
        }
        Result<List<AuditSapVo>> result = auditMatchVoFeign.findByCondition(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 折扣率变量剩余费用池余额 统计
     *
     * @param dto
     * @return Map<String, String>
     */
    @Override
    public List<SurplusFeePoolBalanceAuditMatchVo> surplusFeePoolBalance(SurplusFeePoolBalanceAuditMatchDto dto) {
        if (ObjectUtils.isEmpty(dto)) {
            return new ArrayList<>();
        }
        Result<List<SurplusFeePoolBalanceAuditMatchVo>> result = auditMatchVoFeign.surplusFeePoolBalance(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }
}
