package com.biz.crm.kms.business.audit.match.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.audit.match.local.service.AuditSapService;
import com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Title: Sap105Consumer
 * @Package: com.biz.crm.kms.business.invoice.returns.order.local.consumer
 * @Description:
 * @Author: wuxia
 * @Date: 2022/11/23 - 5:47 PM
 */

@Slf4j
@Component
@RocketMQMessageListener(topic = AuditMatchConstant.KMS_SAP_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = AuditMatchConstant.KMS_SAP_REDIS_MESSAGE_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = AuditMatchConstant.KMS_SAP_REDIS_MESSAGE_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class Sap105Consumer extends AbstractRocketMqConsumer {

    @Autowired
    private AuditSapService auditSapService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("稽核自动匹配MQ接收成功;");
        try {
            String date = String.valueOf(JSON.parse(message.getMsgBody()));
            log.info("===== 自动抓取开始 ======");
            this.auditSapService.zmfi105(date);
            log.info("===== 自动抓取完成 ======");
        } catch (Exception e) {
            log.error("", e);
        }
        return "消费成功";
    }
}
