package com.biz.crm.kms.business.audit.match.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchConsequenceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 稽查匹配结果表(AuditMatchConsequence)表相关的http接口
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
@RestController
@RequestMapping("/v1/auditMatch/auditMatchConsequence")
@Slf4j
@Api(tags = "稽查匹配：AuditMatchConsequence：稽查匹配结果表")
public class AuditMatchConsequenceController {

  /**
   * 服务对象
   */
  @Autowired
  private AuditMatchConsequenceService auditMatchConsequenceService;

  /**
   * 根据稽核单号集合批量确认
   *
   * @param auditCodes 稽核单号集合
   * @return 修改结果
   */
  @ApiOperation(value = "根据稽核单号集合批量确认")
  @PatchMapping
  public Result<?> updateConfirmStatusByAuditCodes(@ApiParam(name = "auditCodes", value = "稽核单号") @RequestBody List<String> auditCodes) {
    try {
      this.auditMatchConsequenceService.updateConfirmStatusByAuditCodes(auditCodes);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
