package com.biz.crm.kms.business.audit.match.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchQueryDto;
import com.biz.crm.mn.third.system.dataphin.sdk.DataphinService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 稽查匹配表(AuditMatch)表相关的http接口
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
@RestController
@RequestMapping("/v1/auditMatch/auditMatch")
@Slf4j
@Api(tags = "稽查匹配：AuditMatch：稽查匹配表")
public class AuditMatchController {

  /**
   * 服务对象
   */
  @Autowired
  private AuditMatchService auditMatchService;

  @Autowired(required = false)
  private DataphinService dataphinService;

  /**
   * 测试105数据抓取
   *
   * @param dto 条件
   */
  @ApiOperation(value = "测试105数据抓取")
  @PostMapping("testConn")
  public Result<?> testConn(@RequestBody AuditMatchQueryDto dto) {
    try {
//      this.dataphinService.getZmfi105Total("20221231");
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AuditMatch> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AuditMatch auditMatch = this.auditMatchService.findById(id);
      return Result.ok(auditMatch);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动稽核匹配
   *
   * @param dto 条件
   */
  @ApiOperation(value = "手动稽核匹配")
  @PostMapping("updateAuditStatusByAuditMatchQueryDto")
  public Result<?> updateAuditStatusByAuditMatchQueryDto(@RequestBody AuditMatchQueryDto dto) {
    try {
      this.auditMatchService.updateAuditStatusByAuditMatchQueryDto(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 自动稽核匹配
   */
  @ApiOperation(value = "自动稽核匹配")
  @PostMapping("autoAuditMatch")
  public Result<?> autoAuditMatch() {
    try {
      this.auditMatchService.autoAuditMatch();
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 自动稽核匹配TEST
   */
  @ApiOperation(value = "自动稽核匹配TEST")
  @GetMapping("autoAuditMatchTEST")
  public Result<?> autoAuditMatchTEST(@RequestParam(value = "auditCodes") List<String> auditCodes) {
    try {
      this.auditMatchService.autoAuditMatchTest(auditCodes);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 抽取SAP数据
   */
  @ApiModelProperty(value = "抽取SAP数据")
  @GetMapping("/extractSapData")
  public Result<?> extractSapData(@ApiParam(value = "抽取时间范围开始时间")@RequestParam(value = "sapDateStart") String sapDateStart,
                                  @ApiParam(value = "抽取时间范围结束时间")@RequestParam(value = "sapDateEnd") String sapDateEnd,
                                  @ApiParam(value = "系统编码") @RequestParam(value = "directCode")String directCode,
                                  @ApiParam(value = "送达方编码") @RequestParam(value = "deliveryCode",required = false)String deliveryCode){
    try{
      String result = this.auditMatchService.extractSapData(sapDateStart,sapDateEnd,directCode,deliveryCode);
      return Result.ok(result);
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新稽核单虚出库
   */
  @ApiModelProperty(value = "更新稽核单虚出库")
  @PostMapping("/updateVirtualStockOut")
  public Result<?> updateVirtualStockOut(@ApiParam(value = "集合单号")@RequestBody List<String> auditCodes){
    try{
      this.auditMatchService.updateVirtualStockOut(auditCodes);
      return Result.ok();
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除稽核单
   */
  @ApiModelProperty(value = "删除稽核单")
  @DeleteMapping("/deleteAuditMatch")
  public Result deleteAuditMatch(@RequestParam("ids") List<String> ids){
    try{
      this.auditMatchService.deleteAuditMatchByIds(ids);
      return Result.ok();
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
