package com.biz.crm.kms.business.audit.match.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchInvoiceService;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 稽查匹配关联单据表(AuditMatchInvoice)表相关的http接口
 *
 * @author songjingen
 * @since 2022-11-10 10:06:39
 */
@RestController
@RequestMapping("/v1/auditMatchInvoice/auditMatchInvoice")
@Slf4j
@Api(tags = "稽查匹配关联单据表：AuditMatchInvoice：稽查匹配关联单据表")
public class AuditMatchInvoiceController {

  /**
   * 服务对象
   */
  @Autowired
  private AuditMatchInvoiceService auditMatchInvoiceService;

  /**
   * 删除匹配单据（取消单据）
   *
   * @param ids 主键集合
   * @return
   */
  @DeleteMapping
  @ApiOperation(value = "删除匹配单据")
  public Result<?> deleteByInvoiceTypeAndIds(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.auditMatchInvoiceService.deleteByInvoiceTypeAndIds(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动匹配单据接口
   * @param auditMatchInvoice
   */
  @ApiModelProperty("手动匹配单据接口")
  @PostMapping("/addMatching")
  public Result<?> addMatching(@RequestBody List<AuditMatchInvoice> auditMatchInvoice){
    try {
      this.auditMatchInvoiceService.addMatching(auditMatchInvoice,null);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @GetMapping("findInvoiceByAuditCode")
  @ApiOperation("根据稽核编号查询稽核匹配单据")
  public Result<InvoiceVo> findInvoiceByAuditCode(@ApiParam(name = "auditCode", value = "稽核单号") @RequestParam(value = "auditCode") String auditCode) {
    try {
      return Result.ok(this.auditMatchInvoiceService.findInvoiceByAuditCode(auditCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
