package com.biz.crm.kms.business.audit.match.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditMatchVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.MatchInvoiceAcceptance;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * 稽查匹配表(AuditMatchVo)表相关的http接口
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
@RestController
@RequestMapping("/v1/auditMatch/auditMatchVo")
@Slf4j
@Api(tags = "稽查匹配：AuditMatchVo：稽查匹配vo")
public class AuditMatchVoController {

  /**
   * 服务对象
   */
  @Autowired
  private AuditMatchVoService auditMatchVoService;

  /**
   * 新增数据
   *
   * @param dtos 实体对象dto
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<?> createBatch(@ApiParam(name = "dtos", value = "实体对象dto") @RequestBody List<AuditMatchDto> dtos) {
    try {
      this.auditMatchVoService.createBatch(dtos);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 查找该单据未关联的验收单
   * @param pageable
   * @param id
   * @param startTime
   * @param endTime
   * @param orderNumber
   * @return
   */
  @ApiOperation("查找该单据未关联的验收单")
  @GetMapping("/notMatchInvoiceAcceptance")
  public Result<List<MatchInvoiceAcceptance>> notMatchInvoiceAcceptance(@PageableDefault(50) Pageable pageable,@RequestParam(value = "id") String id,
                                                                        @RequestParam(value = "startTime",required = false) String startTime,@RequestParam(value = "endTime",required = false) String endTime,
                                                                        @RequestParam(value = "orderNumber",required = false) String orderNumber){
    try {
      List<MatchInvoiceAcceptance> MatchInvoiceAcceptances = this.auditMatchVoService.notMatchInvoiceAcceptance(pageable,id,startTime,endTime,orderNumber);
      return Result.ok(MatchInvoiceAcceptances);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查找该单据未关联的验收单
   * @param id
   */
  @ApiOperation("查找该单据未关联的退货单")
  @GetMapping("/notMatchInvoiceReturn")
  public Result<List<InvoiceReturnOrderVo>> notMatchInvoiceReturn(@PageableDefault(50) Pageable pageable,@RequestParam(value = "id") String id){
    try {
      List<InvoiceReturnOrderVo> returnOrderVos = this.auditMatchVoService.notMatchInvoiceReturn(pageable,id);
      return Result.ok(returnOrderVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 添加或修改备注
   * @param id
   * @param remake
   */
  @ApiOperation("新增或修改备注")
  @GetMapping("/addOrUpdateRemake")
  public Result<?> addOrUpdateRemake(@RequestParam String id,@RequestParam String remake){
    try {
      this.auditMatchVoService.addOrUpdateRemake(id, remake);
      return Result.ok();
    }catch (RuntimeException e){
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
