package com.biz.crm.kms.business.audit.match.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.local.service.AuditSapService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 稽核Sap数据(AuditSap)表相关的接口
 *
 * @author cyj
 * @since 2022-12-19 17:18:44
 */
@RestController
@RequestMapping("/v1/auditSap/auditSap")
@Slf4j
@Api(tags = "稽核Sap数据：auditSap：稽核SAP数据表")
public class AuditSapController {

    @Autowired(required = false)
    private AuditSapService auditSapService;

    @ApiOperation(value = "通过SAP单号和物料编码查询数据")
    @GetMapping("/findBySapCode")
    public Result<List<AuditSapVo>> findBySapCodeAndMaterialCode(@ApiParam(name = "sapCode", value = "sap编码") @RequestParam(value = "sapCode",required = false) String sapCode
            , @ApiParam(name = "materialCode",value = "sap物料编码")@RequestParam(value = "materialCode",required = false) String materialCode) {
        try {
            List<AuditSapVo> entities = this.auditSapService.findBySapCode(sapCode,materialCode);
            return Result.ok(entities);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "通过SAP单校验字段查询数据")
    @GetMapping("/findByVerifyCode")
    public Result<List<AuditSapVo>> findByVerifyCode(@ApiParam(name = "verifyCode", value = "校验字段") @RequestParam(value = "verifyCode",required = false) String verifyCode) {
        try {
            List<AuditSapVo> entities = this.auditSapService.findByVerifyCode(verifyCode);
            return Result.ok(entities);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "自动转换稽核数据定时任务")
    @GetMapping("/autoExtractSapData")
    public Result<?> autoExtractSapData() {
        try {
            this.auditSapService.autoExtractSapData();
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    /**
     * 手动同步某一天的垂直出库单(日期格式20220103)
     *
     * @param date 条件
     */
    @ApiOperation(value = "手动同步某一天的垂直出库单(日期格式20220103)")
    @GetMapping("sync105ByDate")
    public Result<?> sync105ByDate(@RequestParam("date")String date) {
        try {
            this.auditSapService.zmfi105(date);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据分页同步105数据
     *
     * @param date 条件
     */
    @ApiOperation(value = "手动同步某一天的垂直出库单(日期格式20220103)")
    @GetMapping("sync105ByPage")
    public Result<?> sync105ByDate(@RequestParam("date")String date,@RequestParam("startPageNum")int startPageNum,@RequestParam("endPageNum")int endPageNum,@RequestParam("pageSize")int pageSize) {
        try {
            this.auditSapService.zmfi105ByPage(date,startPageNum,endPageNum,pageSize);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 发送MQ抓取105数据
     *
     * @param date 条件
     */
    @ApiOperation(value = "手动同步某一天的垂直出库单(日期格式2022-01-03)")
    @GetMapping("extractZmfi105")
    public Result<?> extractZmfi105(@ApiParam(name = "date", value = "日期") @RequestParam(value = "date")String date) {
        try {
            this.auditSapService.extractZmfi105(date);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
