package com.biz.crm.kms.business.audit.match.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapConditionDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 稽核Sap数据(AuditSap)表相关的接口
 *
 * @author hd
 */
@RestController
@RequestMapping("/v1/auditSap/auditSapVo")
@Slf4j
@Api(tags = "SAP105数据")
public class AuditSapVoController {

    @Autowired(required = false)
    private AuditSapVoService auditSapVoService;

    @ApiOperation(value = "通过条件查询数据")
    @PostMapping("/findByCondition")
    public Result<List<AuditSapVo>> findByCondition(@ApiParam(name = "dto", value = "查询条件对象") @RequestBody AuditSapConditionDto dto) {
        try {
            List<AuditSapVo> entities = this.auditSapVoService.findByCondition(dto);
            return Result.ok(entities);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "折扣率变量剩余费用池余额")
    @PostMapping("/surplusFeePoolBalance")
    public Result<List<SurplusFeePoolBalanceAuditMatchVo>> surplusFeePoolBalance(@ApiParam(name = "dto", value = "查询条件对象") @RequestBody SurplusFeePoolBalanceAuditMatchDto dto) {
        try {
            List<SurplusFeePoolBalanceAuditMatchVo> list = this.auditSapVoService.surplusFeePoolBalance(dto);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
