package com.biz.crm.kms.business.audit.match.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.service.AuditTemplateService;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditTemplateTabVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditTemplateTabVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 稽查模板表(AuditTemplate)表相关的http接口
 *
 * @author songjingen
 * @since 2022-10-13 14:40:26
 */
@RestController
@RequestMapping("/v1/auditMatch/auditTemplate")
@Slf4j
@Api(tags = "稽查匹配：AuditTemplate：稽查模板表")
public class AuditTemplateController {

  /**
   * 服务对象
   */
  @Autowired
  private AuditTemplateService auditTemplateService;

  @Autowired
  private AuditTemplateTabVoService templateTabVoService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AuditTemplate> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AuditTemplate auditTemplate = this.auditTemplateService.findById(id);
      return Result.ok(auditTemplate);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param auditTemplate 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<AuditTemplate> create(@ApiParam(name = "auditTemplate", value = "稽查模板表") @RequestBody AuditTemplate auditTemplate) {
    try {
      AuditTemplate result = this.auditTemplateService.create(auditTemplate);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param auditTemplate 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<AuditTemplate> update(@ApiParam(name = "auditTemplate", value = "稽查模板表") @RequestBody AuditTemplate auditTemplate) {
    try {
      AuditTemplate result = this.auditTemplateService.update(auditTemplate);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.auditTemplateService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.auditTemplateService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.auditTemplateService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @GetMapping("findTemplateTab")
  @ApiOperation(value = "稽核模板Tab")
  public Result<?> findTemplateTab(@ApiParam(name = "templateName", value = "模板名称") @RequestParam(value = "templateName",required = false)String templateName) {
    try {
      List<AuditTemplateTabVo> tabVo = this.templateTabVoService.findByTemplateName(templateName);
      return Result.ok(tabVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
