package com.biz.crm.kms.business.audit.match.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.audit.match.sdk.service.InvoiceMatchVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceMatchVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 单据匹配vo控制层
 *
 * @author songjingen
 */
@RequestMapping("/v1/auditMatch/invoiceMatchVo")
@RestController
@Api(tags = "稽查匹配：InvoiceMatchVo：单据匹配vo")
@Slf4j
public class InvoiceMatchVoController {

  @Autowired(required = false)
  private InvoiceMatchVoService invoiceMatchVoService;

  /**
   * 查询所有单据匹配数据
   *
   * @return 对象集合
   */
  @ApiOperation(value = "查询所有单据匹配数据")
  @GetMapping("findAll")
  public Result<List<InvoiceMatchVo>> findAll() {
    try {
      List<InvoiceMatchVo> invoiceMatchVos = this.invoiceMatchVoService.findAll();
      return Result.ok(invoiceMatchVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据匹配逻辑编码查询数据
   *
   * @return 对象
   */
  @ApiOperation(value = "根据匹配逻辑编码查询数据")
  @GetMapping("findByMatchLogicCode")
  public Result<InvoiceMatchVo> findByMatchLogicCode(@ApiParam(name = "matchLogicCode", value = "匹配逻辑编码") @RequestParam(value = "matchLogicCode") String matchLogicCode) {
    try {
      InvoiceMatchVo invoiceMatchVo = this.invoiceMatchVoService.findByMatchLogicCode(matchLogicCode);
      return Result.ok(invoiceMatchVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
