package com.biz.crm.kms.business.audit.match.local.controller;


import com.biz.crm.kms.business.audit.match.local.entity.KmsAuditSummary;
import com.biz.crm.kms.business.audit.match.local.service.KmsAuditSummaryService;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Delete;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 稽核汇总表(KmsAuditSummary)表相关的http接口
 *
 * @author cyj
 * @since 2023-01-04 14:44:49
 */
@RestController
@RequestMapping("/v1/kmsAuditSummary")
@Slf4j
@Api(tags = "稽核汇总表")
public class KmsAuditSummaryController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private KmsAuditSummaryService kmsAuditSummaryService;

    /**
     * 分页查询所有数据
     *
     * @param pageable        分页对象
     * @param kmsAuditSummary 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<KmsAuditSummary>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "kmsAuditSummary", value = "稽核汇总表") KmsAuditSummary kmsAuditSummary) {
        try {
            Page<KmsAuditSummary> page = this.kmsAuditSummaryService.findByConditions(pageable, kmsAuditSummary);
            return Result.ok(page);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<KmsAuditSummary> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            KmsAuditSummary kmsAuditSummary = this.kmsAuditSummaryService.findById(id);
            return Result.ok(kmsAuditSummary);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param kmsAuditSummary 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<KmsAuditSummary> create(@ApiParam(name = "kmsAuditSummary", value = "稽核汇总表") @RequestBody KmsAuditSummary kmsAuditSummary) {
        try {
            KmsAuditSummary result = this.kmsAuditSummaryService.create(kmsAuditSummary);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param kmsAuditSummary 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<KmsAuditSummary> update(@ApiParam(name = "kmsAuditSummary", value = "稽核汇总表") @RequestBody KmsAuditSummary kmsAuditSummary) {
        try {
            KmsAuditSummary result = this.kmsAuditSummaryService.update(kmsAuditSummary);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
        try {
            this.kmsAuditSummaryService.delete(idList);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 稽核汇总
     * @param auditTemplateCode
     * @param beginDate
     * @param endDate
     * @return
     */
    @ApiOperation(value = "稽核汇总")
    @GetMapping("/summaryAudit")
    public Result<?> summaryAudit(@ApiParam(name = "auditTemplateCode", value = "模板编码") @RequestParam("auditTemplateCode") String auditTemplateCode,
                                  @ApiParam(name = "beginDate",value = "开始时间") @RequestParam("beginDate") String beginDate,
                                  @ApiParam(name = "endDate",value = "开始时间") @RequestParam("endDate") String endDate) {
        try {
            this.kmsAuditSummaryService.summaryAudit(auditTemplateCode,beginDate,endDate);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除稽核汇总
     * @param ids
     * @return
     */
    @ApiOperation(value = "删除稽核汇总")
    @DeleteMapping("/deleteAuditSummary")
    public Result deleteAuditSummary(@RequestParam("ids") List<String> ids) {
        try {
            this.kmsAuditSummaryService.deleteAuditSummary(ids);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
