package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 稽查匹配表（稽核数据）
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_match")
@Table(name = "kms_audit_match", indexes = {
    @Index(name = "kms_audit_match_index1", columnList = "audit_code,tenant_code", unique = true),
    @Index(name = "kms_audit_match_index2", columnList = "audit_code"),
    @Index(name = "kms_audit_match_index2", columnList = "template_code"),
})
@ApiModel(value = "AuditMatch", description = "稽查匹配表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_match", comment = "稽查匹配表")
public class AuditMatch extends TenantFlagOpEntity {

  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
  @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '业态[数据字典:mdm_business_format] '")
  private String businessFormatCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
  @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '业务单元[数据字典:mdm_business_unit] '")
  private String businessUnitCode;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @Column(name = "template_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /**
   * 稽核单号
   */
  @ApiModelProperty("稽核单号")
  @Column(name = "audit_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '稽核单号'")
  private String auditCode;

  @ApiModelProperty("零售商名称")
  @Column(name = "ka_name", length = 32, columnDefinition = "varchar(32) COMMENT '零售商名称'")
  private String kaName;

  @ApiModelProperty("零售商编码")
  @Column(name = "ka_code", length = 32, columnDefinition = "varchar(32) COMMENT '零售商编码'")
  private String kaCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统名称")
  @Column(name = "direct_name", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '系统名称'")
  private String directName;

  /**
   * 门店编码
   */
  @ApiModelProperty("门店编码")
  @Column(name = "store_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '门店编码'")
  private String storeCode;

  /**
   * SAP单号
   */
  @ApiModelProperty("SAP单号")
  @Column(name = "sap_order_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT 'SAP单号'")
  private String sapOrderCode;

  /**
   * 关联结算单号
   */
  @ApiModelProperty("关联结算单号")
  @TableField(value = "statement_code")
  @Column(name = "statement_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联结算单号'")
  private String statementCode;

  /**
   * SAP过账日期
   */
  @ApiModelProperty("SAP过账日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "sap_posting_date", length = 20, nullable = false, columnDefinition = "datetime COMMENT 'SAP过账日期 '")
  private Date sapPostingDate;

  @ApiModelProperty("售达方名称")
  @TableField(value = "sold_to_party_name")
  @Column(name = "sold_to_party_name", length = 256, columnDefinition = "varchar(256) COMMENT '售达方名称'")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  @TableField(value = "sold_to_party_code")
  @Column(name = "sold_to_party_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方编码'")
  private String soldToPartyCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  @Column(name = "delivery_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '送达方编码'")
  private String deliveryCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  @Column(name = "delivery_name", columnDefinition = "varchar(255) COMMENT '送达方名称'")
  private String deliveryName;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  @Column(name = "business_area", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域'")
  private String businessArea;

  /**
   * SAP物料号
   */
  @ApiModelProperty("SAP物料号")
  @Column(name = "sap_material_code", length = 128, columnDefinition = "varchar(128) COMMENT 'SAP物料号'")
  private String sapMaterialCode;

  /**
   * SAP物料名称
   */
  @ApiModelProperty("SAP物料名称")
  @Column(name = "sap_material_name", columnDefinition = "varchar(255) COMMENT 'SAP物料名称'")
  private String sapMaterialName;

  /**
   * SAP单数量（EA）
   */
  @ApiModelProperty("SAP单数量（EA）")
  @Column(name = "sap_ea_count", nullable = false, columnDefinition = "decimal(20,4) COMMENT 'SAP单数量（EA）'")
  private BigDecimal sapEaCount;

  /**
   * sap总金额
   */
  @ApiModelProperty("SAP总金额")
  @Column(name = "sap_total_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT 'sap总金额'")
  private BigDecimal sapTotalAmount;

  /**
   * sap总金额（不含税）
   */
  @ApiModelProperty("sap总金额（不含税）")
  @Column(name = "sap_total_amount_tax_exclusive", nullable = false, columnDefinition = "decimal(20,4) COMMENT 'sap总金额（不含税）'")
  private BigDecimal sapTotalAmountTaxExclusive;

  /**
   * 配送方编码
   */
  @ApiModelProperty("配送方编码")
  @Column(name = "shipping_by_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '配送方编码'")
  private String shippingByCode;

  /**
   * 配送方名称
   */
  @ApiModelProperty("配送方名称")
  @Column(name = "shipping_by_name", columnDefinition = "varchar(255) COMMENT '配送方名称'")
  private String shippingByName;

  /**
   * 匹配状态
   */
  @ApiModelProperty("匹配状态")
  @Column(name = "match_status", length = 16, columnDefinition = "varchar(16) COMMENT '匹配状态'")
  private String matchStatus;

  /**
   * 待匹配天数
   */
  @ApiModelProperty("待匹配天数")
  @Column(name = "wait_days", length = 8, nullable = false, columnDefinition = "int(8) COMMENT '待匹配天数'")
  private Integer waitDays;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", length = 400, columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

  /**
   * 稽核结果
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("稽核结果")
  private AuditMatchConsequence matchConsequences;

  /**
   * 匹配逻辑编码
   */
  @ApiModelProperty("匹配逻辑编码")
  @Column(name = "match_logic_code", length = 500, nullable = false, columnDefinition = "varchar(500) COMMENT '匹配逻辑编码'")
  private String matchLogicCode;

  /**
   * 完成日期
   */
  @ApiModelProperty("完成日期")
  @Column(name = "finish_time", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '完成日期'")
  private String finishTime;

  /**
   * 采购单号
   */
  @ApiModelProperty("采购单号")
  @Column(name = "relation_order_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '采购单号'")
  private String relationOrderCode;

  /**
   * 完成人
   */
  @ApiModelProperty("完成人")
  @Column(name = "finish_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '完成人'")
  private String finishName;

  /**
   * sap单价
   */
  @ApiModelProperty("sap单价")
  @Column(name = "sap_price", nullable = false, columnDefinition = "decimal(20,4) COMMENT 'sap单价（不含税）'")
  private BigDecimal sapPrice;

  /**
   * 销售订单
   */
  @ApiModelProperty("销售订单")
  @Column(name = "sales_order_number",length = 32, columnDefinition = "varchar(32) COMMENT '销售订单'")
  private String salesOrderNumber;

  /**
   * 省编码(门店管理-省)
   */
  @ApiModelProperty("省编码(门店管理-省)")
  @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
  private String provinceCode;

  /**
   * 省名称(门店管理-省)
   */
  @ApiModelProperty("省名称(门店管理-省)")
  @Column(name = "province_name", length = 32, columnDefinition = "varchar(32) COMMENT '省名称(门店管理-省)'")
  private String provinceName;

  /**
   * 匹配单据详情
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("匹配单据详情")
  private InvoiceVo invoiceVo;

  /**
   * 105原单据校验字段(查询可用)
   */
  @ApiModelProperty("105原单据校验字段")
  @Column(name = "verify_code", length = 32, columnDefinition = "varchar(32) COMMENT '105原单据校验字段'")
  private String verifyCode;

  /**
   * 未匹配原因
   */
  @ApiModelProperty("未匹配原因")
  @Column(name = "not_match_reason",length = 255, columnDefinition = "varchar(255) COMMENT '未匹配原因'")
  private String notMatchReason;

  @ApiModelProperty("零售商门店编码")
  @Column(name = "ka_store_code", length = 32,  columnDefinition = "varchar(64) COMMENT '零售商门店编码'")
  private String kaStoreCode;

  @ApiModelProperty("零售商门店名称")
  @Column(name = "ka_store_name", length = 64,  columnDefinition = "varchar(64) COMMENT '零售商门店名称'")
  private String kaStoreName;

  /**
   * 新单号
   */
  @ApiModelProperty("新单号")
  @Column(name = "cross_order_number", length = 32, columnDefinition = "varchar(32) COMMENT '新单号'")
  private String crossOrderNumber;
}
