package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 稽查匹配结果表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_match_consequence")
@Table(name = "kms_audit_match_consequence", indexes = {
    @Index(name = "kms_audit_match_consequence_index1", columnList = "audit_code,tenant_code", unique = true),
    @Index(name = "kms_audit_match_consequence_index3", columnList = "audit_code"),
})
@ApiModel(value = "AuditMatchConsequence", description = "稽查匹配结果表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_match_consequence", comment = "稽查匹配结果表")
public class AuditMatchConsequence extends TenantOpEntity {

  /**
   * 稽核单号
   */
  @ApiModelProperty("稽核单号")
  @Column(name = "audit_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '稽核单号'")
  private String auditCode;

  /**
   * 匹配结果，0-无差异，1-有差异
   */
  @ApiModelProperty("匹配结果，0-无差异，1-有差异")
  @Column(name = "match_consequence", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '匹配结果，0-无差异，1-有差异'")
  private String matchConsequence;

  /**
   * 确认状态,0-未确认，1-已确认
   */
  @ApiModelProperty("确认状态,0-未确认，1-已确认")
  @Column(name = "confirm_status", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '确认状态,0-未确认，1-已确认'")
  private Boolean confirmStatus = false;

  /**
   * 单据总数量
   */
  @ApiModelProperty("单据总数量")
  @Column(name = "invoice_total_count", columnDefinition = "decimal(20,4) COMMENT '单据总数量'")
  private BigDecimal invoiceTotalCount;

  /**
   * 数量差异
   */
  @ApiModelProperty("数量差异")
  @Column(name = "quantity_variance", columnDefinition = "decimal(20,4) COMMENT '数量差异'")
  private BigDecimal quantityVariance;

  /**
   * 单据总金额
   */
  @ApiModelProperty("单据总金额")
  @Column(name = "invoice_total_amount", columnDefinition = "decimal(20,4) COMMENT '单据总金额'")
  private BigDecimal invoiceTotalAmount;

  /**
   * 单据总金额（不含税）
   */
  @ApiModelProperty("单据总金额（不含税）")
  @Column(name = "invoice_total_amount_tax_exclusive", columnDefinition = "decimal(20,4) COMMENT '单据总金额（不含税）'")
  private BigDecimal invoiceTotalAmountTaxExclusive;

  /**
   * 金额差异
   */
  @ApiModelProperty("金额差异")
  @Column(name = "amount_variance", columnDefinition = "decimal(20,4) COMMENT '金额差异'")
  private BigDecimal amountVariance;

  /**
   * 金额差异（不含税）
   */
  @ApiModelProperty("金额差异（不含税）")
  @Column(name = "amount_variance_tax_exclusive", columnDefinition = "decimal(20,4) COMMENT '金额差异（不含税）'")
  private BigDecimal amountVarianceTaxExclusive;

  /**
   * 单据单价
   */
  @ApiModelProperty("单据含税单价")
  @Column(name = "invoice_price", columnDefinition = "decimal(20,4) COMMENT '单据含税单价'")
  private BigDecimal invoicePrice;

  /**
   * 单据未税单价
   */
  @ApiModelProperty("单据未税单价")
  @Column(name = "invoice_price_no_tax", columnDefinition = "decimal(20,4) COMMENT '单据未税单价'")
  private BigDecimal invoicePriceNoTax;

  /**
   * 单价差异
   */
  @ApiModelProperty("单价差异")
  @Column(name = "amount_variance_price", columnDefinition = "decimal(20,4) COMMENT '单价差异'")
  private BigDecimal amountVariancePrice;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @Column(name = "template_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /**
   * 差异类型
   */
  @ApiModelProperty("差异类型,0等于价差 1等于量差 2等于价差丨量差")
  @Column(name = "differ_type", length = 8, columnDefinition = "varchar(8) COMMENT '差异类型,0等于价差 1等于量差 2等于价差丨量差'")
  private String differType;

  /**
   * 稽核单校验编码
   */
  @ApiModelProperty("稽核单校验编码")
  @Column(name = "verify_code", length = 128, columnDefinition = "varchar(128) COMMENT '稽核单校验编码'")
  private String verifyCode;
}
