package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/3/9 14:59
 * @description 稽核窜单验收关系表
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_match_cross_acceptance")
@Table(name = "kms_audit_match_cross_acceptance", indexes = {
        @Index(name = "kms_audit_match_cross_acceptance_index1", columnList = "id", unique = true)
})
@ApiModel(value = "AuditMatchCrossAcceptance", description = "稽核窜单验收关联表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_match_cross_acceptance", comment = "稽核窜单验收关联表")
public class AuditMatchCrossAcceptance extends TenantFlagOpEntity {

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @Column(name = "sale_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织编码'")
    private String saleOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn("销售组织名称")
    @Column(name = "sale_org_name", length = 64, columnDefinition = "varchar(64) COMMENT '销售组织名称'")
    private String saleOrgName;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
    private String directCode;

    /**
     * 系统名称
     */
    @ApiModelProperty("系统名称")
    @Column(name = "direct_name", length = 64, columnDefinition = "varchar(64) COMMENT '系统名称'")
    private String directName;

    /**
     * 交货单号
     */
    @ApiModelProperty("交货单号")
    @Column(name = "sales_delivery_no", length = 32, columnDefinition = "varchar(32) COMMENT '交货单号'")
    private String salesDeliveryNo;

    /**
     * 交货单行号
     */
    @ApiModelProperty("交货单行号")
    @Column(name = "sales_delivery_no_item", length = 16, columnDefinition = "varchar(16) COMMENT '交货单行号'")
    private String salesDeliveryNoItem;

    /**
     * SAP过账日期
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "sap_posting_date", length = 20, nullable = false, columnDefinition = "datetime COMMENT 'SAP过账日期 '")
    private Date sapPostingDate;

    /**
     * 订单抬头备注
     */
    @ApiModelProperty("订单抬头备注")
    @Column(name = "order_header", length = 255, columnDefinition = "varchar(255) COMMENT '订单抬头备注'")
    private String orderHeader;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "sap_material_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String sapMaterialCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "sap_material_name", length = 32, columnDefinition = "varchar(32) COMMENT '产品名称'")
    private String sapMaterialName;

    /**
     * 原出库数量
     */
    @ApiModelProperty("原出库数量")
    @Column(name = "order_num", columnDefinition = "decimal(20,4) COMMENT '原出库数量'")
    private BigDecimal orderNum;

    /**
     * 窜单号
     */
    @ApiModelProperty("窜单号")
    @Column(name = "cross_order_number", length = 32, columnDefinition = "varchar(32) COMMENT '窜单号'")
    private String crossOrderNumber;

    /**
     * 窜单号类型
     */
    @ApiModelProperty("窜单号类型")
    @Column(name = "cross_order_type", length = 8, columnDefinition = "varchar(8) COMMENT '窜单号类型'")
    private String crossOrderType;

    /**
     * 窜单号是否抓回
     */
    @ApiModelProperty("窜单号是否已抓回")
    @Column(name = "is_cross_order_garb", length = 8, columnDefinition = "varchar(8) COMMENT '窜单号是否已抓回'")
    private String isCrossOrderGarb;

    /**
     * 窜单验收数量
     */
    @ApiModelProperty("窜单验收数量")
    @Column(name = "cross_order_num", length = 32, columnDefinition = "decimal(20,4) COMMENT '窜单验收数量'")
    private BigDecimal crossOrderNum;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '送达方编码'")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 64, columnDefinition = "varchar(32) COMMENT '送达方名称'")
    private String deliveryPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '售达方编码'")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name", length = 64, columnDefinition = "varchar(64) COMMENT '售达方名称'")
    private String soldToPartyName;

    /**
     *  分仓编码
     */
    @ApiModelProperty("分仓编码")
    @Column(name = "warehouse_code", length = 32, columnDefinition = "varchar(32) COMMENT '分仓编码'")
    private String warehouseCode;

    /**
     *  分仓名称
     */
    @ApiModelProperty("分仓名称")
    @Column(name = "warehouse_name", length = 64, columnDefinition = "varchar(64) COMMENT '分仓名称'")
    private String warehouseName;

    /**
     * 关联稽核单号
     */
    @ApiModelProperty("关联稽核单号")
    @Column(name = "audit_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联稽核单号'")
    private String auditCode;

    /**
     * 105原单据校验字段(查询可用)
     */
    @ApiModelProperty("105原单据校验字段")
    @Column(name = "verify_code", length = 32, columnDefinition = "varchar(32) COMMENT '105原单据校验字段'")
    private String verifyCode;

    /**
     * 产品组
     * (例：常温、奶酪)
     */
    @ApiModelProperty("产品组")
    @Column(name = "spart_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品组'")
    private String spartCode;

    /**
     * 异常类型
     */
    @ApiModelProperty("异常类型(1表示整单窜单；2表示部分窜单)")
    @Column(name = "exception_type", length = 32, columnDefinition = "varchar(32) COMMENT '异常类型(1表示整单窜单；2表示部分窜单)'")
    private String exceptionType;
}
