package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 稽查匹配关联单据表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_match_invoice")
@Table(name = "kms_audit_match_invoice", indexes = {
    @Index(name = "kms_audit_match_invoice_index1", columnList = "template_code,invoice_type,invoice_code,relation_id", unique = true),
})
@ApiModel(value = "AuditMatchInvoice", description = "稽查匹配关联单据表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_match_invoice", comment = "稽查匹配关联单据表")
public class AuditMatchInvoice extends UuidEntity {

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @Column(name = "template_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /**
   * 稽核单号
   */
  @ApiModelProperty("稽核单号")
  @Column(name = "audit_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '稽核单号'")
  private String auditCode;

  /**
   * 单据类型
   *
   * @see InvoiceTypeRegister#type()
   */
  @ApiModelProperty("单据类型")
  @Column(name = "invoice_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '单据类型'")
  private String invoiceType;

  /**
   * 单据唯一编码
   */
  @ApiModelProperty("单据唯一编码")
  @Column(name = "invoice_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '单据唯一编码'")
  private String invoiceCode;


  /**
   * 表单关系id
   */
  @ApiModelProperty("表单关系id")
  @Column(name = "relation_id", length = 64, nullable = false, columnDefinition = "varchar(32) COMMENT '表单关系id'")
  private String relationId;
}
