package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 稽核Sap105数据表
 *
 * @author cyj
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_sap")
@Table(name = "kms_audit_sap", indexes = {
    @Index(name = "kms_audit_sap_index1", columnList = "id", unique = true),
    @Index(name = "kms_audit_sap_index1", columnList = "verify_code")
})
@ApiModel(value = "AuditSapEntity", description = "Sap105数据表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_sap", comment = "Sap105数据表")
public class AuditSapEntity extends TenantFlagOpEntity {

  /**
   * 发货过账
   * (确定出库单状态（垂直）)
   */
  @ApiModelProperty("发货过账")
  @Column(name = "goods_move_status", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发货过账'")
  private String goodsMoveStatus;

  /**
   * 发票过账
   * (确定出库单状态（分子公司）)
   */
  @ApiModelProperty("发票过账")
  @Column(name = "gene_accounting_vou_status", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票过账'")
  private String geneAccountingVouStatus;

  /**
   * 销售订单号
   * (出库单行明细汇总)
   */
  @ApiModelProperty("销售订单号")
  @Column(name = "sales_order_no", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '销售订单号'")
  private String salesOrderNo;

  /**
   * 销售组织代码
   * (分子公司的销售组织代码)
   */
  @ApiModelProperty("销售组织代码")
  @Column(name = "sales_org_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '销售组织代码'")
  private String salesOrgCode;

  /**
   * 销售组织描述
   * (分子公司的销售组织名称)
   */
  @ApiModelProperty("销售组织描述")
  @Column(name = "sales_org", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '销售组织描述'")
  private String salesOrg;

  /**
   * 产品组
   * (例：常温、奶酪)
   */
  @ApiModelProperty("产品组")
  @Column(name = "spart_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '产品组'")
  private String spartCode;

  /**
   * 采购订单号
   * (分子公司使用采购订单号记录商超原始订单号)
   */
  @ApiModelProperty("采购订单号")
  @Column(name = "purchase_order_no", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '采购订单号'")
  private String purchaseOrderNo;

  /**
   * 订单抬头备注
   * (垂直使用订单抬头备注记录商超原始订单号)
   */
  @ApiModelProperty("订单抬头备注")
  @Column(name = "order_header", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '订单抬头备注'")
  private String orderHeader;

  /**
   * 订单原因描述
   * (销售订单类型)
   */
  @ApiModelProperty("订单原因描述")
  @Column(name = "order_reason", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '订单原因描述'")
  private String orderReason;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @Column(name = "sale_vou_type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '订单类型'")
  private String saleVouType;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  @Column(name = "dealer_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '售达方编码'")
  private String dealerCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  @Column(name = "dealer_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '售达方名称'")
  private String dealerName;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  @Column(name = "service_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '送达方编码'")
  private String serviceCode;
  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  @Column(name = "service_name", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '送达方名称'")
  private String serviceName;

  /**
   * 交货日期
   * (订单出库后交货日期的记录)
   */
  @ApiModelProperty("交货日期")
  @Column(name = "deliveried_date", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '交货日期'")
  private String deliveriedDate;

  /**
   * 物料编码
   * (产品编码（37码）)
   */
  @ApiModelProperty("物料编码")
  @Column(name = "material_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '物料编码'")
  private String materialCode;

  /**
   * 物料描述
   * (产品名称)
   */
  @ApiModelProperty("物料描述")
  @Column(name = "material_name", length = 256, nullable = false, columnDefinition = "varchar(32) COMMENT '物料描述'")
  private String materialName;

  /**
   * 订单数量
   * (出库单订单数量)
   */
  @ApiModelProperty("订单数量")
  @Column(name = "order_num", length = 32, nullable = false, columnDefinition = "INT(10) COMMENT '订单数量'")
  private Integer orderNum;

  /**
   * 销售单位
   * (（PC，件）)
   */
  @ApiModelProperty("销售单位")
  @Column(name = "sales_unit", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '销售单位'")
  private String salesUnit;

  /**
   * 订单常规价格(ZP01)
   * (直接取折前，105退库会有退货价差，通过此字段和交货数量还原折前金额)
   */
  @ApiModelProperty("订单常规价格(ZP01)")
  @Column(name = "order_regular_price",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单常规价格(ZP01)'")
  private BigDecimal orderRegularPrice;

  /**
   * 订单含返点常规价格(ZP01+ZK18)
   */
  @ApiModelProperty("订单含返点常规价格(ZP01+ZK18)")
  @Column(name = "order_rebate_regular_price",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单含返点常规价格(ZP01+ZK18)'")
  private BigDecimal orderRebateRegularPrice;

  /**
   * 订单活动价格(ZP03)
   */
  @ApiModelProperty("订单活动价格(ZP03)")
  @Column(name = "order_act_price",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单活动价格(ZP03)'")
  private BigDecimal orderActPrice;

  /**
   * 订单折前价格(ZK99)
   */
  @ApiModelProperty("订单折前价格(ZK99)")
  @Column(name = "order_before_discount_price",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单折前价格(ZK99)'")
  private BigDecimal orderBeforeDiscountPrice;

  /**
   * 订单折后价格(KZWI1)
   *(垂直通过订单含返点常规金额与商超验收金额进行对账)
   */
  @ApiModelProperty("订单折后价格(KZWI1)")
  @Column(name = "order_after_discount_price",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单折后价格(KZWI1)'")
  private BigDecimal orderAfterDiscountPrice;

  /**
   * 订单含返点常规金额(ZP01+ZK18)
   */
  @ApiModelProperty("订单含返点常规金额(ZP01+ZK18)")
  @Column(name = "order_rebate_regular_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单含返点常规金额(ZP01+ZK18)'")
  private BigDecimal orderRebateRegularAmt;

  /**
   * 订单折前金额(ZK99)
   *(价格还原)
   */
  @ApiModelProperty("订单折前金额(ZK99)")
  @Column(name = "order_before_discount_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单折前金额(ZK99)'")
  private BigDecimal orderBeforeDiscountAmt;

  /**
   * 订单固定折扣(ZK01)
   */
  @ApiModelProperty("订单固定折扣(ZK01)")
  @Column(name = "order_fix_discount",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单固定折扣(ZK01)'")
  private BigDecimal orderFixDiscount;

  /**
   * 订单折后金额(KZWI1)
   */
  @ApiModelProperty("订单折后金额(KZWI1)")
  @Column(name = "order_after_discount_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '订单折后金额(KZWI1)'")
  private BigDecimal orderAfterDiscountAmt;

  /**
   * 发货过账日期
   */
  @ApiModelProperty("发货过账日期")
  @Column(name = "shipping_account_date", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发货过账日期'")
  private String shippingAccountDate;

  /**
   * 交货单编号
   */
  @ApiModelProperty("交货单编号")
  @Column(name = "sales_delivery_no", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '交货单编号'")
  private String salesDeliveryNo;

  /**
   * 交货单数量
   */
  @ApiModelProperty("交货单数量")
  @Column(name = "delivery_order_num1", length = 32, nullable = false, columnDefinition = "int(10) COMMENT '交货单数量'")
  private Integer deliveryOrderNum1;

  /**
   * 交货单折前金额(ZK99)
   */
  @ApiModelProperty("交货单折前金额(ZK99)")
  @Column(name = "delivery_defore_discount_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '交货单折前金额(ZK99)'")
  private BigDecimal deliveryDeforeDiscountAmt;

  /**
   * 交货单折后金额(KZWI1)
   */
  @ApiModelProperty("交货单折后金额(KZWI1)")
  @Column(name = "delivery_after_discount_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '交货单折后金额(KZWI1)'")
  private BigDecimal deliveryAfterDiscountAmt;

  /**
   * 到货率(%)
   */
  @ApiModelProperty("到货率(%)")
  @Column(name = "arrival_rate",nullable = false, columnDefinition = "decimal(20,2) COMMENT '到货率(%)'")
  private BigDecimal arrivalRate;

  /**
   * 订单数量/基本单位
   */
  @ApiModelProperty("订单数量/基本单位")
  @Column(name = "order_num1", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '订单数量/基本单位'")
  private String orderNum1;

  /**
   * 交货单数量/基本单位
   */
  @ApiModelProperty("交货单数量/基本单位")
  @Column(name = "delivery_order_num", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '交货单数量/基本单位'")
  private String deliveryOrderNum;

  /**
   * 出具发票日期
   */
  @ApiModelProperty("出具发票日期")
  @Column(name = "invoice_date", length = 32, columnDefinition = "varchar(32) COMMENT '出具发票日期'")
  private String invoiceDate;

  /**
   * 发票创建日期
   */
  @ApiModelProperty("发票创建日期")
  @Column(name = "invoice_created_date", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票创建日期'")
  private String invoiceCreatedDate;

  /**
   * 发票金额
   */
  @ApiModelProperty("发票金额")
  @Column(name = "invoice_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '发票金额'")
  private BigDecimal invoiceAmt;

  /**
   * 发票ZK01金额
   */
  @ApiModelProperty("发票ZK01金额")
  @Column(name = "invoice_discount_amt",nullable = false, columnDefinition = "decimal(20,4) COMMENT '发票ZK01金额'")
  private BigDecimal invoiceDiscountAmt;

  /**
   * 发票类型
   */
  @ApiModelProperty("发票类型")
  @Column(name = "invoice_type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票类型'")
  private String invoiceType;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @Column(name = "record_date", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '创建时间'")
  private String recordDate;

  /**
   * 转换状态
   */
  @ApiModelProperty("转换状态")
  @Column(name = "trans_status", length = 8, nullable = false, columnDefinition = "varchar(8) COMMENT '转换状态'")
  private String transStatus;

  /**
   * 时间分区
   */
  @ApiModelProperty("时间分区")
  @Column(name = "ds", length = 16, columnDefinition = "varchar(16) COMMENT '时间分区'")
  private String ds;

  /**
   * 校验字段
   */
  @Column(name = "verify_code", length = 64, columnDefinition = "varchar(64) COMMENT '校验字段(交货单编号+行号)'")
  private String verifyCode;
  /**
   * 交货单行项目号
   */
  @ApiModelProperty("交货单行项目号")
  @Column(name = "sales_delivery_item_no", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '交货单行项目号'")
  private String salesDeliveryItemNo;
  /**
   * 发票状态
   */
  @ApiModelProperty("发票状态")
  @Column(name = "invoice_status", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '发票状态'")
  private String invoiceStatus;

  /**
   * 分销渠道编码
   */
  @ApiModelProperty("分销渠道编码")
  @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
  private String channelCode;

  /**
   * 品类
   */
  @ApiModelProperty(name = "品类编码")
  @Column(name = "category_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码'")
  private String categoryCode;
  /**
   * 品类名称
   */
  @ApiModelProperty(name = "品类名称")
  @Column(name = "category", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品类名称'")
  private String category;
  /**
   * 品项
   */
  @ApiModelProperty(name = "品项编码")
  @Column(name = "item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码'")
  private String itemCode;
  /**
   * 品项名称
   */
  @ApiModelProperty(name = "品项名称")
  @Column(name = "item", length = 64, columnDefinition = "VARCHAR(64) COMMENT '品项名称'")
  private String item;
  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  @Column(name = "basic_unit", length = 32, columnDefinition = "varchar(32) COMMENT '基本单位'")
  private String basicUnit;
  /**
   * 发票税金额
   */
  @ApiModelProperty("发票税金额")
  @Column(name = "invoice_tax_amt", columnDefinition = "decimal(20,4) COMMENT '发票税金额'")
  private BigDecimal invoiceTaxAmt;
  /**
   * 交货单发出重量(毛重)
   */
  @ApiModelProperty("交货单发出重量(毛重)")
  @Column(name = "delivery_order_weight", columnDefinition = "decimal(20,4) COMMENT '交货单发出重量(毛重)'")
  private BigDecimal deliveryOrderWeight;

  @ApiModelProperty("产品品牌编码")
  @Column(name = "product_brand_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品品牌编码 '")
  private String productBrandCode;

  @ApiModelProperty("产品品牌名称")
  @Column(name = "product_brand_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品品牌名称 '")
  private String productBrandName;

  @ApiModelProperty("产品品类编码")
  @Column(name = "product_category_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品品类编码 '")
  private String productCategoryCode;

  @ApiModelProperty("产品品类名称")
  @Column(name = "product_category_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品品类名称 '")
  private String productCategoryName;

  @ApiModelProperty("产品层级编码（品相编码）")
  @Column(name = "product_level_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品层级编码（品相编码） '")
  private String productLevelCode;

  @ApiModelProperty("产品层级名称（品相名称）")
  @Column(name = "product_level_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品层级名称（品相名称） '")
  private String productLevelName;

  /**
   * 是否匹配
   */
  @ApiModelProperty("是否匹配")
  @Column(name = "is_matched", length = 8, columnDefinition = "VARCHAR(8) COMMENT '是否匹配'")
  private String isMatched = "N";

  /**
   * SAP过账日期
   */
  @ApiModelProperty("SAP过账日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "sap_posting_date", length = 20, columnDefinition = "datetime COMMENT 'SAP过账日期 '")
  private Date sapPostingDate;
}
