package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.kms.business.audit.match.sdk.register.InvoiceMatchRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 稽查模板
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_template")
@Table(name = "kms_audit_template", indexes = {
    @Index(name = "kms_audit_template_index1", columnList = "template_code,tenant_code", unique = true),
    @Index(name = "kms_audit_template_index1", columnList = "template_name,tenant_code", unique = true)
})
@ApiModel(value = "AuditTemplate", description = "稽查模板表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_template", comment = "稽查模板表")
public class AuditTemplate extends TenantFlagOpEntity {

  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
  @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '业态[数据字典:mdm_business_format] '")
  private String businessFormatCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
  @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '业务单元[数据字典:mdm_business_unit] '")
  private String businessUnitCode;

  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  @TableField(value = "sales_org_code")
  @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织编码 '")
  private String salesOrgCode;

  /**
   * 销售组织名称
   */
  @TableField(value = "sales_org_name")
  @ApiModelProperty("销售组织名称")
  @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 销售组织名称 '")
  private String salesOrgName;
  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @Column(name = "template_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  @Column(name = "template_name", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '模板名称'")
  private String templateName;

  /**
   * 稽核匹配时间（每日2:30 抽取发货数据并执行自动匹配）
   */
  @ApiModelProperty("稽核匹配时间（格式：HH:mm；eg：每日2:30 抽取发货数据并执行自动匹配）")
  @Column(name = "match_time", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '稽核匹配时间（格式：HH:mm；eg：每日2:30 抽取发货数据并执行自动匹配）'")
  private String matchTime;

  /**
   * 匹配逻辑编码
   *
   * @see InvoiceMatchRegister#getMatchLogicCode()
   */
  @ApiModelProperty("匹配逻辑编码")
  @Column(name = "match_logic_code", length = 500, nullable = false, columnDefinition = "varchar(500) COMMENT '匹配逻辑编码'")
  private String matchLogicCode;

  /**
   * 模板类型
   *
   * @see InvoiceMatchRegister#getMatchLogicDesc()
   */
  @ApiModelProperty("模板类型")
  @Column(name = "match_logic_desc", length = 500, nullable = false, columnDefinition = "varchar(500) COMMENT '模板类型'")
  private String matchLogicDesc;

  /**
   * 单据类型
   *
   * @see InvoiceMatchRegister#getMatchInvoiceType()
   */
  @ApiModelProperty("单据类型，字符串数组")
  @Column(name = "match_invoice_type", length = 500, columnDefinition = "varchar(500) COMMENT '单据类型，字符串数组'")
  private String matchInvoiceType;

  /**
   * 匹配条件
   *
   * @see InvoiceMatchRegister#getMatchParams()
   */
  @ApiModelProperty("匹配条件，字符串数组")
  @Column(name = "match_params", length = 500, columnDefinition = "varchar(500) COMMENT '匹配条件，字符串数组'")
  private String matchParams;

  /**
   * 商超集合
   */
  @ApiModelProperty("商超集合")
  @TableField(exist = false)
  @Transient
  private List<AuditTemplateSupermarket> templateSupermarkets;

  /**
   * 稽核单生成条件
   */
  @ApiModelProperty("稽核单生成条件")
  @Column(name = "create_audit_status", length = 32, columnDefinition = "varchar(32) COMMENT '稽核单生成条件'")
  private String createAuditStatus;
}
