package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.kms.business.audit.match.sdk.enums.PriceTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 稽查模板商超数据表
 *
 * @author songjingen
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_template_supermarket")
@Table(name = "kms_audit_template_supermarket", indexes = {
    @Index(name = "kms_audit_template_supermarket_index1", columnList = "direct_code,template_code", unique = true)
})
@ApiModel(value = "AuditTemplateSupermarket", description = "稽查模板商超数据表")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_template_supermarket", comment = "稽查模板商超数据表")
public class AuditTemplateSupermarket extends UuidEntity {

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @Column(name = "template_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统名称")
  @Column(name = "direct_name", length = 64, columnDefinition = "varchar(64) COMMENT '系统编码'")
  private String directName;

  /**
   * 商超系统编码
   */
  @ApiModelProperty("商超系统编码")
  @Column(name = "supermarket_code",length = 64, columnDefinition = "varchar(64) COMMENT '商超系统编码'")
  private String supermarketCode;

  /**
   * 商超系统名称
   */
  @ApiModelProperty("商超系统名称")
  @Column(name = "supermarket_name",length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '商超系统名称'")
  private String supermarketName;

  /**
   * 价格容差类型 {@link PriceTypeEnum#getDictCode()}
   */
  @ApiModelProperty("价格容差类型")
  @Column(name = "price_type", length = 8, nullable = false, columnDefinition = "varchar(8) COMMENT '价格容差类型'")
  private String priceType;

  /**
   * 价格容差值
   */
  @ApiModelProperty("价格容差值")
  @Column(name = "price_value", nullable = false, columnDefinition = "decimal(20,4) COMMENT '价格容差值'")
  private BigDecimal priceValue;

  /**
   * 时间容差类型 {@link PriceTypeEnum#getDictCode()}
   */
  @ApiModelProperty("时间容差类型")
  @Column(name = "delay_type", length = 8, nullable = false, columnDefinition = "varchar(8) COMMENT '时间容差类型'")
  private String delayType;

  /**
   * 延迟收货天数
   */
  @ApiModelProperty("延迟收货天数")
  @Column(name = "delay_days", length = 8, nullable = false, columnDefinition = "int(8) COMMENT '延迟收货天数'")
  private Integer delayDays;

}
