package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/1/4 14:19
 * @description KmsAuditSummaryEntity
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_audit_summary")
@Table(name = "kms_audit_summary", indexes = {
        @Index(name = "kms_audit_summary_index1", columnList = "id", unique = true),
})
@ApiModel(value = "KmsAuditSummary", description = "稽核汇总")
@org.hibernate.annotations.Table(appliesTo = "kms_audit_summary", comment = "稽核汇总表")
public class KmsAuditSummary extends TenantFlagOpEntity {

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @Column(name = "sales_org_code", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    @Column(name = "sales_org_name", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '销售组织名称'")
    private String salesOrgName;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
    private String directCode;

    /**
     * 系统名称
     */
    @ApiModelProperty("系统名称")
    @Column(name = "direct_name", length = 32, columnDefinition = "varchar(32) COMMENT '系统名称'")
    private String directName;

    /**
     * 105单据量
     */
    @ApiModelProperty("105单据量")
    @Column(name = "sap_total", length = 32, columnDefinition = "varchar(32) COMMENT '105单据量'")
    private BigDecimal sapTotal;

    /**
     * 验收单单据量
     */
    @ApiModelProperty("验收单单据量")
    @Column(name = "acceptance_total", length = 32, columnDefinition = "varchar(32) COMMENT '验收单单据量'")
    private BigDecimal acceptanceTotal;

    /**
     * 已匹配105单据
     */
    @ApiModelProperty("已匹配105单据")
    @Column(name = "sap_total_matched", length = 32, columnDefinition = "varchar(32) COMMENT '已匹配105单据'")
    private BigDecimal sapTotalMatched;

    /**
     * 稽核匹配成功率
     */
    @ApiModelProperty("稽核匹配成功率")
    @Column(name = "audit_success_rate", length = 32, columnDefinition = "decimal(20,4) COMMENT '稽核匹配成功率'")
    private BigDecimal auditSuccessRate;

    /**
     * 稽核匹配差异率
     */
    @ApiModelProperty("稽核匹配差异率")
    @Column(name = "audit_differ_Rate", length = 32, columnDefinition = "decimal(20,4) COMMENT '稽核匹配差异率'")
    private BigDecimal auditDifferRate;

    /**
     * 差异类型
     */
    @ApiModelProperty("差异类型")
    @Column(name = "differ_type", length = 32, columnDefinition = "varchar(256) COMMENT '差异类型'")
    private String differType;

    /**
     * 稽核匹配差异率
     */
    @ApiModelProperty("匹配失败门店量")
    @Column(name = "match_failed_delivery", length = 32, columnDefinition = "decimal(20,4) COMMENT '匹配失败门店量'")
    private BigDecimal matchFailedDelivery;

    /**
     * 稽核匹配差异率
     */
    @ApiModelProperty("匹配失败产品量")
    @Column(name = "match_failed_product", length = 32, columnDefinition = "decimal(20,4) COMMENT '匹配失败产品量'")
    private BigDecimal matchFailedProduct;

    /**
     * 稽核模板编码
     */
    @ApiModelProperty("稽核模板编码")
    @Column(name = "templateCode", columnDefinition = "varchar(32) COMMENT '稽核模板编码'")
    private String templateCode;

    /**
     * 汇总时间范围
     */
    @ApiModelProperty("汇总时间范围（开始时间）")
    @Column(name = "time_range_start", columnDefinition = "varchar(32) COMMENT '汇总时间范围（开始时间）'")
    private String timeRangeStart;

    /**
     * 汇总时间范围
     */
    @ApiModelProperty("汇总时间范围（结束时间）")
    @Column(name = "time_range_end", columnDefinition = "varchar(32) COMMENT '汇总时间范围（结束时间）'")
    private String timeRangeEnd;

    /**
     * 验收单数量
     */
    @ApiModelProperty("验收单头数量")
    @Column(name = "acceptance_order_total", columnDefinition = "decimal(20,4) COMMENT '验收单头数量'")
    private BigDecimal acceptanceOrderTotal;

    /**
     * 验收单转换成功率
     */
    @ApiModelProperty("验收单转换成功率")
    @Column(name = "acceptance_success_rate",columnDefinition = "decimal(20,4) COMMENT '验收单转换成功率'")
    private BigDecimal acceptanceSuccessRate;

    /**
     * 105原始单据量
     */
    @ApiModelProperty("105原始单据量")
    @Column(name = "grab_sap_total",columnDefinition = "decimal(20,4) COMMENT '验收单头数量'")
    private BigDecimal grabSapTotal;
}
