package com.biz.crm.kms.business.audit.match.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/2/9 17:03
 * @description MatchInvoiceManuEntity
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_match_invoice_manu")
@Table(name = "kms_match_invoice_manu", indexes = {
        @Index(name = "kms_match_invoice_manu_index", columnList = "id", unique = true),
        @Index(name = "kms_match_invoice_manu_index2", columnList = "audit_code"),
        @Index(name = "kms_match_invoice_manu_index3", columnList = "audit_code"),
        @Index(name = "kms_match_invoice_manu_index4", columnList = "audit_code"),
})
@ApiModel(value = "MatchInvoiceManuEntity", description = "手动匹配稽核确认验收单明细表")
@org.hibernate.annotations.Table(appliesTo = "kms_match_invoice_manu", comment = "手动匹配稽核确认验收单明细表")
public class MatchInvoiceManuEntity extends TenantFlagOpEntity {

    /**
     * [数据字典:mdm_business_format]
     */
    @ApiModelProperty("业态")
    @Column(name = "business_format_code", length = 64,  columnDefinition = "varchar(64) COMMENT '业态'")
    private String businessFormatCode;

    /**
     * [数据字典:mdm_business_unit]
     */
    @ApiModelProperty("业务单元编码")
    @Column(name = "business_unit_code", length = 64,  columnDefinition = "varchar(64) COMMENT '业务单元编码'")
    private String businessUnitCode;

    @ApiModelProperty("系统编码")
    @Column(name = "direct_code", length = 64,  columnDefinition = "varchar(64) COMMENT '系统编码'")
    private String directCode;

    @ApiModelProperty("关联商超订货单编号")
    @Column(name = "relate_ka_order_number", length = 64,  columnDefinition = "varchar(64) COMMENT '关联商超订货单编号'")
    private String relateKaOrderNumber;

    @ApiModelProperty("企业验收单编号")
    @Column(name = "order_number", length = 64,  columnDefinition = "varchar(64) COMMENT '企业验收单编号'")
    private String orderNumber;

    @ApiModelProperty("商超验收单编号")
    @Column(name = "ka_order_number", length = 64,  columnDefinition = "varchar(64) COMMENT '商超验收单编号'")
    private String kaOrderNumber;

    @ApiModelProperty("验收日期")
    @Column(name = "acceptance_date", length = 64,  columnDefinition = "varchar(64) COMMENT '验收日期'")
    private String acceptanceDate;

    @ApiModelProperty("商超编码")
    @Column(name = "ka_code", length = 64,  columnDefinition = "varchar(64) COMMENT '商超编码'")
    private String kaCode;

    @ApiModelProperty("商超名称")
    @Column(name = "ka_name", length = 64,  columnDefinition = "varchar(64) COMMENT '商超名称'")
    private String kaName;

    @ApiModelProperty("商超门店/大仓编号")
    @Column(name = "ka_store_code", length = 64,  columnDefinition = "varchar(64) COMMENT '商超门店/大仓编号'")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    @Column(name = "ka_store_name", length = 64,  columnDefinition = "varchar(64) COMMENT '商超门店/大仓名称'")
    private String kaStoreName;

    @ApiModelProperty("送达方编码")
    @Column(name = "delivery_party_code", length = 64,  columnDefinition = "varchar(64) COMMENT '送达方编码'")
    private String deliveryPartyCode;

    @ApiModelProperty("送达方名称")
    @Column(name = "delivery_party_name", length = 64,  columnDefinition = "varchar(64) COMMENT '送达方名称'")
    private String deliveryPartyName;

    @ApiModelProperty("业务区域")
    @Column(name = "business_area", length = 64,  columnDefinition = "varchar(64) COMMENT '业务区域'")
    private String businessArea;

    @ApiModelProperty("区域编码")
    @Column(name = "area_code", length = 64,  columnDefinition = "varchar(64) COMMENT '区域编码'")
    private String areaCode;

    @ApiModelProperty("区域名称")
    @Column(name = "area_name", length = 64,  columnDefinition = "varchar(64) COMMENT '区域名称'")
    private String areaName;

    @ApiModelProperty("企业产品编号")
    @Column(name = "goods_code", length = 64,  columnDefinition = "varchar(64) COMMENT '企业产品编号'")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    @Column(name = "goods_name", length = 64,  columnDefinition = "varchar(64) COMMENT '企业产品名称'")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    @Column(name = "ka_goods_code", length = 64,  columnDefinition = "varchar(64) COMMENT '商超产品编号'")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    @Column(name = "ka_goods_name", length = 64,  columnDefinition = "varchar(64) COMMENT '商超产品名称'")
    private String kaGoodsName;

    @ApiModelProperty("当前单位验收数量")
    @Column(name = "cur_unit_acceptance_quantity", columnDefinition = "decimal(20,4) COMMENT '当前单位验收数量'")
    private BigDecimal curUnitAcceptanceQuantity;

    @ApiModelProperty("当前单位验收数量")
    @Column(name = "cur_company_unit_order_quantity", columnDefinition = "decimal(20,4) COMMENT '当前单位验收数量'")
    private BigDecimal curCompanyUnitOrderQuantity;

    @ApiModelProperty("验收金额小计（含税）")
    @Column(name = "acceptance_amount", columnDefinition = "decimal(20,4) COMMENT '验收金额小计（含税）'")
    private BigDecimal acceptanceAmount;

    @ApiModelProperty("验收金额小计（不含税）")
    @Column(name = "acceptance_amount_not", columnDefinition = "decimal(20,4) COMMENT '验收金额小计（不含税）'")
    private BigDecimal acceptanceAmountNot;

    @ApiModelProperty("验收单价")
    @Column(name = "acceptance_one_amount", columnDefinition = "decimal(20,4) COMMENT '验收单价'")
    private BigDecimal acceptanceOneAmount;

    @ApiModelProperty("验收单价(不含税)")
    @Column(name = "acceptance_one_amount_not", columnDefinition = "decimal(20,4) COMMENT '验收单价(不含税)'")
    private BigDecimal acceptanceOneAmountNot;

    @ApiModelProperty("稽核单号")
    @Column(name = "audit_code", length = 64,  columnDefinition = "varchar(64) COMMENT '稽核单号'")
    private String auditCode;

    @ApiModelProperty("系统名称")
    @Column(name = "direct_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统名称'")
    private String directName;

    @ApiModelProperty("售达方名称")
    @Column(name = "sold_to_party_name", length = 256, columnDefinition = "varchar(256) COMMENT '售达方名称'")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    @Column(name = "sold_to_party_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方编码'")
    private String soldToPartyCode;

    @ApiModelProperty("验收单明细行关联id")
    @Column(name = "acceptance_goods_id", length = 64, columnDefinition = "varchar(64) COMMENT '验收单明细行关联id'")
    private String acceptanceGoodsId;
}