package com.biz.crm.kms.business.audit.match.local.export.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchConsequenceDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 稽查匹配dto
 *
 * @author songjingen
 */
@Data
@ApiModel(value = "AuditMatchExportDto", description = "稽核匹配导出入参Dto")
public class AuditMatchExportDto extends TenantFlagOpDto {

  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
  private String businessFormatCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
  private String businessUnitCode;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 稽核单号
   */
  @ApiModelProperty("稽核单号")
  private String auditCode;

  @ApiModelProperty("零售商名称")
  private String kaName;

  @ApiModelProperty("零售商编码")
  private String kaCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统名称")
  private String directName;

  /**
   * 门店编码
   */
  @ApiModelProperty("门店编码")
  private String storeCode;

  /**
   * SAP单号
   */
  @ApiModelProperty("SAP单号")
  private String sapOrderCode;

  /**
   * 关联结算单号
   */
  @ApiModelProperty("关联结算单号")
  private String statementCode;

  /**
   * SAP过账日期
   */
  @ApiModelProperty("SAP过账日期")
  private String sapPostingDate;

  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String deliveryCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String deliveryName;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  private String businessArea;

  /**
   * SAP物料号
   */
  @ApiModelProperty("SAP物料号")
  private String sapMaterialCode;

  /**
   * SAP物料名称
   */
  @ApiModelProperty("SAP物料名称")
  private String sapMaterialName;

  /**
   * SAP单数量（EA）
   */
  @ApiModelProperty("SAP单数量（EA）")
  private BigDecimal sapEaCount;

  /**
   * sap总金额
   */
  @ApiModelProperty("SAP总金额")
  private BigDecimal sapTotalAmount;

  /**
   * sap总金额（不含税）
   */
  @ApiModelProperty("sap总金额（不含税）")
  private BigDecimal sapTotalAmountTaxExclusive;

  /**
   * 配送方编码
   */
  @ApiModelProperty("配送方编码")
  private String shippingByCode;

  /**
   * 配送方名称
   */
  @ApiModelProperty("配送方名称")
  private String shippingByName;

  /**
   * 匹配状态
   */
  @ApiModelProperty("匹配状态")
  private String matchStatus;

  /**
   * 待匹配天数
   */
  @ApiModelProperty("待匹配天数")
  private Integer waitDays;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 稽核结果
   */
  @ApiModelProperty("稽核结果")
  private AuditMatchConsequenceDto matchConsequences;

  /**
   * 匹配逻辑编码
   */
  @ApiModelProperty("匹配逻辑编码")
  private String matchLogicCode;

  /**
   * 完成日期
   */
  @ApiModelProperty("完成日期")
  private String finishTime;

  /**
   * 采购单号
   */
  @ApiModelProperty("采购单号")
  private String relationOrderCode;

  /**
   * 完成人
   */
  @ApiModelProperty("完成人")
  private String finishName;

  /**
   * 未匹配原因
   */
  @ApiModelProperty("未匹配原因")
  private String notMatchReason;

  /**
   * 校验字段
   */
  @ApiModelProperty("校验字段")
  private String verifyCode;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  private String beginDate;

  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  private String endDate;
}
