package com.biz.crm.kms.business.audit.match.local.export.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.kms.business.audit.match.local.export.dto.AuditMatchExportDto;
import com.biz.crm.kms.business.audit.match.local.export.mapper.AuditMatchExportMapper;
import com.biz.crm.kms.business.audit.match.local.export.vo.AuditMatchExportVo;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Class AuditMatchExportProcess
 * @Description 稽核匹配导出
 * @Author : cyj
 * @Date: 2023/2/4  17:16
 */
@Component
public class AuditMatchExportProcess implements ExportProcess<AuditMatchExportVo> {

    @Autowired(required = false)
    private AuditMatchExportMapper auditMatchExportMapper;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        AuditMatchExportDto dto = this.convertParams(params);
        Page<AuditMatchExportVo> pageResult = this.auditMatchExportMapper.findByConditions(new Page<>(0, 1), dto);
        return ((int) (pageResult.getTotal()));
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo processVo, Map<String, Object> params) {
        //分页问题修改
        if(processVo.getPageNo() == null || processVo.getPageSize() ==null){
            throw new IllegalArgumentException("参数错误");
        }
        processVo.setPageNo(processVo.getPageNo()+1);
        AuditMatchExportDto dto = this.convertParams(params);
        Page<AuditMatchExportDto> pageable = new Page<>(processVo.getPageNo(), this.getPageSize());
        Page<AuditMatchExportVo> page = this.auditMatchExportMapper.findByConditions(pageable, dto);
        this.buildVo(page.getRecords());
        return JSON.parseArray(JSON.toJSONString((page.getRecords())));
    }

    @Override
    public Class<AuditMatchExportVo> findCrmExcelVoClass() {
        return AuditMatchExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "KMS_AUDIT_MATCH_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "KMS稽核-稽核匹配导出";
    }

    /**
     * 转换参数
     *
     * @param params 传递参数
     * @return 转换结果
     */
    private AuditMatchExportDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        params.remove("sort");
        params.remove("europaInfoCode");
        String templateCode = null;
        if (Objects.nonNull(params.get("directCode"))){
            templateCode = params.get("directCode").toString();
        }
        params.remove("directCode");
        Map<String, Object> map = params.entrySet().stream()
                .collect(Collectors.toMap(e -> e.getKey().substring(0, e.getKey().lastIndexOf("_")), Map.Entry::getValue,(a,b)->a));
        List<String> dateList = new ArrayList<>();
        params.forEach((k,v)->{
            if (k.contains("sap_posting_date")){
                dateList.add(v.toString());
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dateList)){
            Collections.sort(dateList);
            if (dateList.size() > 1){
                map.put("beginDate",dateList.get(0));
                map.put("endDate",dateList.get(1));
            }
        }
        AuditMatchExportDto dto = JSON.parseObject(JSON.toJSONString(map), AuditMatchExportDto.class);
        if (StringUtils.isNotEmpty(templateCode)){
            dto.setTemplateCode(templateCode);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        return dto;
    }

    private void buildVo(List<AuditMatchExportVo> page){
        if (CollectionUtils.isEmpty(page)){
            return;
        }
        Map<String, String> bussinessAreaMap = new HashMap<>();
        List<DictDataVo> bussinessArea = dictDataVoService.findByDictTypeCode("MDM_CUSTOMIZE_ORG");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(bussinessArea)){
            bussinessAreaMap = bussinessArea.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (a,b) ->a));
        }
        for (AuditMatchExportVo auditMatchExportVo : page) {
            auditMatchExportVo.setMatchStatus(MatchStatusEnum.getByDictCode(auditMatchExportVo.getMatchStatus()).getValue());
            auditMatchExportVo.setBusinessArea(bussinessAreaMap.get(auditMatchExportVo.getBusinessArea()));
        }
    }
}
