package com.biz.crm.kms.business.audit.match.local.export.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 稽查匹配vo
 *
 * @author songjingen
 */
@Data
@ApiModel(value = "AuditMatchExportVo", description = "稽核匹配导出Vo")
@CrmExcelExport
public class AuditMatchExportVo extends CrmExcelVo {

  /**
   * 稽核单号
   */
  @CrmExcelColumn("*稽核单号")
  private String auditCode;

  /**
   * 系统编码
   */
  @CrmExcelColumn("*系统编码")
  private String directCode;

  /**
   * 系统名称
   */
  @CrmExcelColumn("*系统名称")
  private String directName;

  /**
   * SAP出库单号
   */
  @CrmExcelColumn("*SAP出库单号")
  private String sapOrderCode;

  /**
   * SAP交货日期
   */
  @CrmExcelColumn("*SAP交货日期")
  private String postDate;

  /**
   * 关联订单号
   */
  @CrmExcelColumn("*采购单号")
  private String relationOrderCode;

  /**
   * 送达方编码
   */
  @CrmExcelColumn("*送达方编码")
  private String deliveryCode;

  /**
   * 送达方名称
   */
  @CrmExcelColumn("*送达方名称")
  private String deliveryName;

  @CrmExcelColumn("*零售商门店编码")
  private String kaStoreCode;

  @CrmExcelColumn("*零售商门店名称")
  private String kaStoreName;

  /**
   * SAP物料号
   */
  @CrmExcelColumn("*SAP物料号")
  private String sapMaterialCode;

  /**
   * SAP物料名称
   */
  @CrmExcelColumn("*SAP物料名称")
  private String sapMaterialName;

  /**
   * SAP单数量（EA）
   */
  @CrmExcelColumn("*SAP单数量")
  private BigDecimal sapEaCount;

  /**
   * SAP总金额
   */
  @CrmExcelColumn("*SAP总金额")
  private BigDecimal sapTotalAmount;

  /**
   * SAP总金额（不含税）
   */
  @CrmExcelColumn("*SAP总金额（不含税）")
  private BigDecimal sapTotalAmountTaxExclusive;

  /**
   * SAP出库价格（含税）
   */
  @CrmExcelColumn("SAP出库价格（含税）")
  private BigDecimal sapPrice;


  /**
   * 匹配状态
   */
  @CrmExcelColumn("*匹配状态")
  private String matchStatus;

  /**
   * 备注
   */
  @CrmExcelColumn("*备注")
  private String remark;

  /**
   * 模板编码
   */
  @CrmExcelColumn("*模板编码")
  private String templateCode;

  /**
   * 数量差异
   */
  @CrmExcelColumn("*数量差异")
  private BigDecimal quantityVariance;

  /**
   * 金额差异
   */
  @CrmExcelColumn("*金额差异")
  private BigDecimal amountVariance;

  /**
   * 单价差异
   */
  @CrmExcelColumn("*单价差异")
  private BigDecimal amountVariancePrice;


  /**
   * 金额差异（不含税）
   */
  @CrmExcelColumn("*金额差异（不含税）")
  private BigDecimal amountVarianceTaxExclusive;

  @CrmExcelColumn("*转换后数量")
  private BigDecimal curCompanyUnitOrderQuantity;

  @CrmExcelColumn("*验收单价")
  private BigDecimal acceptanceOneAmount;

  @CrmExcelColumn("*企业验收单编号")
  private String orderNumber;

  @CrmExcelColumn("*商超验收单编号")
  private String kaOrderNumber;

  @CrmExcelColumn("*企业产品编号")
  private String goodsCode;

  @CrmExcelColumn("企业产品名称")
  private String goodsName;

  @CrmExcelColumn("*商超产品编号")
  private String kaGoodsCode;

  @CrmExcelColumn("*商超产品名称")
  private String kaGoodsName;

  @CrmExcelColumn("*验收金额小计（含税）")
  private BigDecimal acceptanceAmount;

  @CrmExcelColumn("*验收金额小计（不含税）")
  private BigDecimal acceptanceAmountNot;

  @CrmExcelColumn("*售达方名称")
  private String soldToPartyName;

  @CrmExcelColumn("*售达方编码")
  private String soldToPartyCode;

  @CrmExcelColumn("*验收日期")
  private String acceptanceDate;

  @CrmExcelColumn("*业务区域")
  private String businessArea;

  /**
   * 未匹配原因
   */
  @CrmExcelColumn("*未匹配原因")
  private String notMatchReason;

  /**
   * 校验字段
   */
  @CrmExcelColumn("*校验字段")
  private String verifyCode;
}
