package com.biz.crm.kms.business.audit.match.local.imports.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/3/9 14:36
 * @description 窜单验收导入关系vo
 */
@Data
@CrmExcelImport(startRow = 2)
public class AuditMatchCrossAcceptanceImportVo extends CrmExcelVo {

    /**
     * 销售组织
     */
    @CrmExcelColumn("*销售组织编码")
    private String saleOrgCode;

    /**
     * 交货单号
     */
    @CrmExcelColumn("*交货单号")
    private String salesDeliveryNo;

    /**
     * 交货单行号
     */
    @CrmExcelColumn("*交货单行项目号")
    private String salesDeliveryNoItem;

    /**
     * 交货日期
     */
    @CrmExcelColumn("*交货日期")
    private String sapPostingDateStr;

    /**
     * 送达方编码
     */
    @CrmExcelColumn("*送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方编码
     */
    @CrmExcelColumn("*送达方名称")
    private String deliveryPartyName;

    /**
     * 产品组(利润中心)
     */
    @CrmExcelColumn("产品组(利润中心)")
    private String spartCode;

    /**
     * 产品编码
     */
    @CrmExcelColumn("*产品编码")
    private String sapMaterialCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String sapMaterialName;

    /**
     * 订单抬头备注
     */
    @CrmExcelColumn("*订单抬头备注")
    private String orderHeader;

    /**
     * 原出库数量
     */
    @CrmExcelColumn("原出库数量")
    private String orderNumStr;

    /**
     * 窜单号
     */
    @CrmExcelColumn("新单号")
    private String crossOrderNumber;

    /**
     * 窜单号类型
     */
    @CrmExcelColumn("*新单号类型(1表示采购订单；2表示验收单)")
    private String crossOrderType;

    /**
     * 窜单验收数量
     */
    @CrmExcelColumn("新单号-验收数量")
    private String crossOrderNumStr;

    /**
     *  备注
     */
    @CrmExcelColumn("其他备注")
    private String remark;

    /**
     * 异常类型
     */
    @CrmExcelColumn("*异常类型(1表示整单窜单；2表示部分窜单)")
    private String exceptionType;


}
