package com.biz.crm.kms.business.audit.match.local.imports.service;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchCrossAcceptance;
import com.biz.crm.kms.business.audit.match.local.imports.model.AuditMatchCrossAcceptanceImportVo;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchCrossAcceptanceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditSapRepository;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.AuditMatchCrossTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.SapOrderTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.acceptance.sdk.service.InvoiceAcceptanceVoService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceGoodsVo;
import com.biz.crm.kms.business.invoice.sdk.enums.ConstantEnums;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import liquibase.pro.packaged.B;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant.KMS_AUDIT_SAP_LOOP_MAX;
import static com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant.KMS_AUDIT_SAP_PAGE_SIZE;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/3/1 17:30
 * @description 稽核匹配更新采购单号导入
 */
@Slf4j
@Component
public class AuditMatchCrossAcceptanceImportProcess implements ImportProcess<AuditMatchCrossAcceptanceImportVo> {

    @Autowired(required = false)
    private DirectVoService directVoService;

    @Autowired(required = false)
    private DirectStoreVoService directStoreVoService;

    @Autowired(required = false)
    private AuditSapRepository auditSapRepository;

    @Autowired(required = false)
    private DirectProductVoService directProductVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private InvoiceAcceptanceVoService invoiceAcceptanceVoService;

    @Autowired(required = false)
    private AuditMatchCrossAcceptanceRepository auditMatchCrossAcceptanceRepository;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditMatchCrossAcceptanceImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(data.values())) {
            return Maps.newHashMap();
        }
        log.info("-------------------------------------导入开始-------------------------------------");
        List<AuditMatchCrossAcceptanceImportVo> importVoList = data.values().stream().collect(Collectors.toList());
        //校验单号
        List<String> verifyCodes = importVoList.stream().map(vo ->{
            String key = StringUtils.join(vo.getSalesDeliveryNo(), String.format("%06d",Integer.valueOf(vo.getSalesDeliveryNoItem())));
            return key;
        }).collect(Collectors.toList());

        //查询105数据
        Pageable auditSapVoPageable = PageRequest.of(1,KMS_AUDIT_SAP_PAGE_SIZE);
        List<AuditSapVo> auditSapVoList = new ArrayList<>();
        AuditSapDto sapDto = new AuditSapDto();
        sapDto.setTenantCode(TenantUtils.getTenantCode());
        sapDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        sapDto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
        sapDto.setSaleVouType(SapOrderTypeEnum.ZOR2.getValue());
        sapDto.setVerifyCodes(verifyCodes);
        Page<AuditSapVo> pageByConditions = this.auditSapRepository.findPageByConditions(auditSapVoPageable, sapDto);
        auditSapVoList.addAll(pageByConditions.getRecords());
        while (pageByConditions.hasNext()
                && KMS_AUDIT_SAP_LOOP_MAX >= auditSapVoPageable.getPageNumber()) {
            auditSapVoPageable = auditSapVoPageable.next();
            pageByConditions = this.auditSapRepository.findPageByConditions(auditSapVoPageable, sapDto);
            auditSapVoList.addAll(pageByConditions.getRecords());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(auditSapVoList)){
            throw new IllegalArgumentException("未根据交货单号和交货单行号查询到原105数据!");
        }
        Map<String, AuditSapVo> sapVoMap = auditSapVoList.stream().collect(Collectors.toMap(AuditSapVo::getVerifyCode, Function.identity(), (a, b) -> a));
        //构建系统信息
        List<String> serviceCodes = auditSapVoList.stream().map(AuditSapVo::getServiceCode).distinct().collect(Collectors.toList());
        Map<String, DirectVo> directVoMap = this.buildDirectVoInfo(serviceCodes);

        //查询门店信息
        List<DirectStoreVo> directStoreVos = directStoreVoService.findByDeliveryCodes(serviceCodes);
        if (org.springframework.util.CollectionUtils.isEmpty(directStoreVos)){
            throw new IllegalArgumentException("未根据送达方查询到系统和门店信息!");
        }

        //根据系统，送达方，物料编码去找上架产品
        Set<String> directCodes = directVoMap.values().stream().map(DirectVo::getDirectCode).collect(Collectors.toSet());
        Set<String> productCodes = auditSapVoList.stream().map(AuditSapVo::getMaterialCode).collect(Collectors.toSet());
        Map<String, List<DirectProductVo>> productMaps = this.buildProductInfo(directCodes, serviceCodes.stream().collect(Collectors.toSet()), productCodes);

        //找验收单(采购单号，验收单号)
        List<String> crossAcceptanceType = importVoList.stream().map(AuditMatchCrossAcceptanceImportVo::getCrossOrderType).distinct().collect(Collectors.toList());
        Map<String,List<InvoiceAcceptanceGoodsVo>> invoiceAcceptanceMap = new HashMap<>();
        if (crossAcceptanceType.contains(AuditMatchCrossTypeEnum.RELATIONKACODE.getDictCode())){
            List<String> relationKaOrderNumber = importVoList.stream().filter(vo ->StringUtils.equals(AuditMatchCrossTypeEnum.RELATIONKACODE.getDictCode(),vo.getCrossOrderType())).map(AuditMatchCrossAcceptanceImportVo::getCrossOrderNumber).distinct().collect(Collectors.toList());
            List<InvoiceAcceptanceGoodsVo> relationKaOrderVo = this.invoiceAcceptanceVoService.findByOrderNumberOrRelationKaOrderNumber(null,relationKaOrderNumber);
            if (!org.springframework.util.CollectionUtils.isEmpty(relationKaOrderVo)){
                Map<String, List<InvoiceAcceptanceGoodsVo>> collect = relationKaOrderVo.stream().collect(Collectors.groupingBy(InvoiceAcceptanceGoodsVo::getRelationKaOrderNumber));
                invoiceAcceptanceMap.putAll(collect);
            }
        }
        if (crossAcceptanceType.contains(AuditMatchCrossTypeEnum.ORDERNUMBER.getDictCode())){
            List<String> orderNumber = importVoList.stream().filter(vo ->StringUtils.equals(AuditMatchCrossTypeEnum.ORDERNUMBER.getDictCode(),vo.getCrossOrderType())).map(AuditMatchCrossAcceptanceImportVo::getCrossOrderNumber).distinct().collect(Collectors.toList());
            List<InvoiceAcceptanceGoodsVo> orderNumberVo = this.invoiceAcceptanceVoService.findByOrderNumberOrRelationKaOrderNumber(orderNumber,null);
            if (!org.springframework.util.CollectionUtils.isEmpty(orderNumberVo)) {
                Map<String, List<InvoiceAcceptanceGoodsVo>> collect = orderNumberVo.stream().collect(Collectors.groupingBy(InvoiceAcceptanceGoodsVo::getOrderNumber));
                invoiceAcceptanceMap.putAll(collect);
            }
        }

        //校验保存逻辑
        List<AuditMatchCrossAcceptance> auditMatchCrossAcceptanceList = new ArrayList<>();
        StringBuilder error = new StringBuilder();
        Map<Integer, String> response = Maps.newHashMap();
        for (Map.Entry<Integer, AuditMatchCrossAcceptanceImportVo> importVo : data.entrySet()) {
            Integer index = importVo.getKey();
            AuditMatchCrossAcceptanceImportVo vo = importVo.getValue();
            if (StringUtils.isEmpty(vo.getSaleOrgCode())){
                error.append("未填写销售组织!");
            }
            if (StringUtils.isEmpty(vo.getSalesDeliveryNo())){
                error.append("未填写交货单号!");
            }
            if (StringUtils.isEmpty(vo.getSalesDeliveryNoItem())){
                error.append("未填写交货单行号!");
            }
            if (StringUtils.isEmpty(vo.getSapPostingDateStr())){
                error.append("未填写交货日期!");
            }
            if (StringUtils.isEmpty(vo.getDeliveryPartyCode())){
                error.append("未填写送达方编码!");
            }
            if (StringUtils.isEmpty(vo.getSapMaterialCode())){
                error.append("未填写物料编码!");
            }
            if (StringUtils.isEmpty(vo.getOrderHeader())){
                error.append("未填写订单抬头!");
            }
            if (StringUtils.isEmpty(vo.getCrossOrderNumber())){
                error.append("未填写新单号!");
            }
            if (StringUtils.isEmpty(vo.getCrossOrderType())){
                error.append("未填写新单号类型!");
            }
            if (StringUtils.isEmpty(vo.getCrossOrderNumStr())){
                error.append("未填写新单号-验收数量");
            }
            if (StringUtils.isEmpty(vo.getExceptionType())){
                error.append("未填写异常类型!");
            }
            String key = StringUtils.join(vo.getSalesDeliveryNo(), String.format("%06d",Integer.valueOf(vo.getSalesDeliveryNoItem())));
            AuditSapVo auditSapVo = sapVoMap.get(key);
            if (Objects.isNull(auditSapVo)){
                error.append("未根据交货单号和交货单行号找到原始105数据!");
            }
            AuditMatchCrossAcceptance auditMatchCrossAcceptance = this.nebulaToolkitService.copyObjectByWhiteList(vo,AuditMatchCrossAcceptance.class, HashSet.class,ArrayList.class);
            DirectVo directVo = directVoMap.get(vo.getDeliveryPartyCode());
            if (Objects.isNull(directVo)) {
                error.append("未根据送达方编码找到系统!");
            }
            try {
                auditMatchCrossAcceptance.setCrossOrderNum(new BigDecimal(vo.getCrossOrderNumStr()));
            }catch (Exception e){
                error.append("请填写正确的数量!");
            }
            Date dateByFormat = com.biz.crm.mn.common.base.util.DateUtil.getDateByFormat(vo.getSapPostingDateStr(), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
            if (Objects.isNull(dateByFormat)){
                error.append("请填写正确的时间格式!");
            }
            auditMatchCrossAcceptance.setCrossOrderNum(new BigDecimal(auditSapVo.getOrderNum1()));
            if (auditMatchCrossAcceptance.getCrossOrderNum().compareTo(auditMatchCrossAcceptance.getCrossOrderNum()) > 0){
                error.append("窜单数量不能大于原单数量!");
            }
            List<InvoiceAcceptanceGoodsVo> invoiceAcceptanceGoodsVos = invoiceAcceptanceMap.get(vo.getCrossOrderNumber());
            if (CollectionUtil.isNotEmpty(invoiceAcceptanceGoodsVos)){
                auditMatchCrossAcceptance.setIsCrossOrderGarb(BooleanEnum.TRUE.getCapital());
            }else {
                auditMatchCrossAcceptance.setIsCrossOrderGarb(BooleanEnum.FALSE.getCapital());
            }
            if (error.length() > 0) {
                response.put(index, error.toString());
                continue;
            }
            auditMatchCrossAcceptance.setTenantCode(TenantUtils.getTenantCode());
            auditMatchCrossAcceptance.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditMatchCrossAcceptance.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            auditMatchCrossAcceptance.setSapPostingDate(com.biz.crm.mn.common.base.util.DateUtil.getDateByFormat(this.transition(auditSapVo.getShippingAccountDate()), com.biz.crm.mn.common.base.util.DateUtil.DEFAULT_YEAR_MONTH_DAY));
            auditMatchCrossAcceptance.setVerifyCode(auditSapVo.getVerifyCode());
            auditMatchCrossAcceptance.setDirectCode(directVo.getDirectCode());
            auditMatchCrossAcceptance.setDirectName(directVo.getSupermarketName());
            auditMatchCrossAcceptance.setSaleOrgName(directVo.getSalesOrgName());
            auditMatchCrossAcceptance.setOrderNum(new BigDecimal(auditSapVo.getOrderNum1()));
            auditMatchCrossAcceptance.setSoldToPartyCode(auditSapVo.getDealerCode());
            auditMatchCrossAcceptance.setSoldToPartyName(auditSapVo.getDealerName());
            auditMatchCrossAcceptance.setDeliveryPartyCode(auditSapVo.getServiceCode());
            auditMatchCrossAcceptance.setDeliveryPartyName(auditSapVo.getServiceName());
            auditMatchCrossAcceptance.setSapMaterialCode(auditSapVo.getMaterialCode());
            auditMatchCrossAcceptance.setSapMaterialName(auditSapVo.getMaterialName());
            //获取物料
            DirectProductVo productVo = this.getGoodsInfo(auditMatchCrossAcceptance, productMaps);
            if (Objects.nonNull(productVo)) {
                auditMatchCrossAcceptance.setSapMaterialName(productVo.getProductName());
            } else {
                auditMatchCrossAcceptance.setSapMaterialName("未根据条件查询到上架产品!");
            }
            auditMatchCrossAcceptanceList.add(auditMatchCrossAcceptance);
        }
        if (MapUtils.isNotEmpty(response)){
            return response;
        }else {
            log.info("-----------------------------窜单导入完成!-----------------------------");
            if (CollectionUtil.isNotEmpty(auditMatchCrossAcceptanceList)){
                this.auditMatchCrossAcceptanceRepository.saveBatch(auditMatchCrossAcceptanceList);
            }
            return new HashMap<>();
        }
    }

    @Override
    public Class<AuditMatchCrossAcceptanceImportVo> findCrmExcelVoClass() {
        return AuditMatchCrossAcceptanceImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "KMS_AUDIT_MATCH_CROSS_ACCEPTANCE_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "稽核窜单验收模板";
    }

    public String getBusinessCode(){return "KMS_AUDIT_IMPORT";}

    public String getBusinessName(){return "稽核匹配导入";}

    /**
     * 构建系统信息
     * @param serviceCodes
     * @return
     */
    private Map<String, DirectVo> buildDirectVoInfo(List<String> serviceCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(serviceCodes)) {
            return null;
        }
        //根据送达方去找系统
        List<DirectStoreVo> directStoreVos = directStoreVoService.findByDeliveryCodes(serviceCodes);
        Validate.isTrue(!CollectionUtil.isEmpty(directStoreVos), "未根据送达方查询到系统和门店信息!");
        Map<String, String> directStoreVoMap = directStoreVos.stream().collect(Collectors.toMap(DirectStoreVo::getTerminalCode, DirectStoreVo::getDirectCode, (a, b) -> a));
        List<String> directCodes = directStoreVos.stream().map(DirectStoreVo::getDirectCode).distinct().collect(Collectors.toList());
        List<DirectVo> directVoList = directVoService.findByDirectCodes(directCodes);
        Map<String, DirectVo> directVoMap = directVoList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, Function.identity()));
        Map<String, DirectVo> resultDirectVoMap = new HashMap<>();
        if (!org.springframework.util.CollectionUtils.isEmpty(directVoMap)) {
            for (String service : directStoreVoMap.keySet()) {
                if (directVoMap.containsKey(directStoreVoMap.get(service))) {
                    resultDirectVoMap.put(service, directVoMap.get(directStoreVoMap.get(service)));
                }
            }
        }
        return resultDirectVoMap;
    }

    /**
     * 构建商品信息
     *
     * @param deliveryPartyCodeSet
     * @param productCodes
     * @return
     */
    private Map<String, List<DirectProductVo>> buildProductInfo(Set<String> directCodeSet,
                                                                Set<String> deliveryPartyCodeSet,
                                                                Set<String> productCodes) {
        Map<String, List<DirectProductVo>> directProductMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(directCodeSet)
                || CollectionUtil.isEmpty(deliveryPartyCodeSet)
                || CollectionUtil.isEmpty(productCodes)) {
            return directProductMap;
        }
        List<List<String>> productCodeGroupList = com.google.common.collect.Lists.partition(Lists.newArrayList(productCodes), ConstantEnums.PRODUCT_SIZE.getValue());
        DirectProductDto directProductDto = new DirectProductDto();
        directProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        directProductDto.setTenantCode(TenantUtils.getTenantCode());
        directProductDto.setOnShelfStatus(BooleanEnum.TRUE.getCapital());
        directProductDto.setDirectCodes(new ArrayList<>(directCodeSet));
        directProductDto.setDeliveryPartyCodes(new ArrayList<>(deliveryPartyCodeSet));
        directProductDto.setOrderType("acceptance");
        productCodeGroupList.forEach(productCodeList -> {
            directProductDto.setProductCodes(productCodeList);
            List<DirectProductVo> productList = this.directProductVoService.findByDirectProductDto(directProductDto);
            if (CollectionUtil.isNotEmpty(productList)) {
                directProductMap.putAll(productList.stream()
                        .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getOnShelfStatus()))
                        .filter(k -> StringUtils.isNotBlank(k.getDirectCode()))
                        .filter(k -> StringUtils.isNotBlank(k.getDeliveryPartyCode()))
                        .filter(k -> StringUtils.isNotBlank(k.getProductCode()))
                        .collect(Collectors.groupingBy(k -> k.getDirectCode()
                                + "_" + k.getDeliveryPartyCode()
                                + "_" + k.getProductCode())));
            }
        });
        return directProductMap;
    }

    /**
     * @param prodDate
     * @return
     */
    private String transition(String prodDate) {
        StringBuffer str = new StringBuffer(prodDate);
        str.insert(6, "-");
        str.insert(4, "-");
        return String.valueOf(str);
    }

    /**
     * 构建商品转换明细信息
     *
     * @param auditMatchCrossAcceptance
     * @param directProductMap
     * @return
     */
    private DirectProductVo getGoodsInfo(AuditMatchCrossAcceptance auditMatchCrossAcceptance,
                                         Map<String, List<DirectProductVo>> directProductMap) {
        DirectProductVo productVo = null;
        if (StringUtils.isBlank(auditMatchCrossAcceptance.getSapMaterialCode())) {
            return null;
        }
        if (MapUtils.isEmpty(directProductMap)) {
            return null;
        }
        List<DirectProductVo> productVoList = directProductMap.get(auditMatchCrossAcceptance.getDirectCode() + "_" +
                auditMatchCrossAcceptance.getDeliveryPartyCode() + "_" + auditMatchCrossAcceptance.getSapMaterialCode());
        if (CollectionUtil.isEmpty(productVoList)) {
            return null;
        } else  {
            productVo = productVoList.get(0);
        }
        return productVo;
    }
}
