package com.biz.crm.kms.business.audit.match.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.imports.model.AuditMatchUpdateImportVo;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.financial.auditing.sdk.service.AuditService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/3/1 17:30
 * @description 稽核匹配更新采购单号导入
 */
@Slf4j
@Component
public class AuditMatchUpdateImportProcess implements ImportProcess<AuditMatchUpdateImportVo> {

    @Autowired(required = false)
    private AuditMatchService auditMatchService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditMatchUpdateImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(data.values())) {
            return Maps.newHashMap();
        }
        log.info("-------------------------------------导入开始-------------------------------------");
        List<AuditMatchUpdateImportVo> importVoList = data.values().stream().collect(Collectors.toList());
        List<AuditMatch> auditMatches = new ArrayList<>();
        for (AuditMatchUpdateImportVo auditMatchUpdateImportVo : importVoList) {
            Validate.isTrue(StringUtils.isNotEmpty(auditMatchUpdateImportVo.getSalesDeliveryNo()),"请填写交货单号!");
            Validate.isTrue(StringUtils.isNotEmpty(auditMatchUpdateImportVo.getItem()),"请填写交货单行号!");
            Validate.isTrue(StringUtils.isNotEmpty(auditMatchUpdateImportVo.getRelationOrderCode()),"请填写采购单号!");
            AuditMatch auditMatch = new AuditMatch();
            try {
                String verifyCode = StringUtils.join(auditMatchUpdateImportVo.getSalesDeliveryNo(), String.format("%06d",Integer.valueOf(auditMatchUpdateImportVo.getItem())));
                auditMatch.setVerifyCode(verifyCode);
                auditMatch.setRelationOrderCode(auditMatchUpdateImportVo.getRelationOrderCode());
                auditMatches.add(auditMatch);
            }catch (Exception e){
                throw new IllegalArgumentException("请在交货单行号输入数字!");
            }
        }
        if (CollectionUtils.isNotEmpty(auditMatches)){
            this.auditMatchService.updateRelationOrderCode(auditMatches);
        }
        return Maps.newHashMap();
    }

    @Override
    public Class<AuditMatchUpdateImportVo> findCrmExcelVoClass() {
        return AuditMatchUpdateImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "KMS_AUDIT_MATCH_UPDATE_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "稽核匹配更新采购单号";
    }

    public String getBusinessCode(){return "KMS_AUDIT_IMPORT";}

    public String getBusinessName(){return "稽核匹配导入";}
}
