package com.biz.crm.kms.business.audit.match.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.MatchInvoiceAcceptance;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽查匹配关联单据表(AuditMatchInvoice)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-11-10 10:06:40
 */
public interface AuditMatchInvoiceMapper extends BaseMapper<AuditMatchInvoice> {

    /**
     * 查询匹配的验收单
     * @param relationIds
     * @return
     */
    List<MatchInvoiceAcceptance> matchInvoice(@Param("relationIds") List<String> relationIds);

    /**
     * 匹配的退货单
     * @param relationIds
     * @return
     */
    List<InvoiceReturnOrderVo> matchInvoiceReturn(@Param("relationIds") List<String> relationIds);


}

