package com.biz.crm.kms.business.audit.match.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapDto;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditMatchVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.MatchInvoiceAcceptance;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 稽查匹配表(AuditMatch)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
public interface AuditMatchMapper extends BaseMapper<AuditMatch> {

    /**
     * 查询未匹配的验收单
     * @param page
     * @param directCode
     * @param storeCodes
     * @param productCodes
     * @param startTime
     * @param endTime
     * @param orderNumber
     * @param orderCodes
     * @param soldPartyCodes
     * @return
     */
    List<MatchInvoiceAcceptance> notMatchInvoice(Page<MatchInvoiceAcceptance> page, @Param("directCode") String directCode,
                                                 @Param("storeCodes") List<String> storeCodes,
                                                 @Param("productCodes") List<String> productCodes,
                                                 @Param("startTime") String startTime,
                                                 @Param("endTime") String endTime,
                                                 @Param("orderNumber") String orderNumber,
                                                 @Param("orderCodes")List<String> orderCodes,
                                                 @Param("soldPartyCodes")List<String> soldPartyCodes);

    /**
     * 未匹配的退货单
     * @param directCode
     * @param soldToPartyCode
     * @param storeCode
     * @return
     */
    List<InvoiceReturnOrderVo> notMatchInvoiceReturn(Page<InvoiceReturnOrderVo> page,@Param("directCode") String directCode, @Param("soldToPartyCode") String soldToPartyCode, @Param("storeCode") String storeCode);

    /**
     * 分页查询数据
     * @param page
     * @param auditMatchDto
     * @return
     */
    Page<AuditMatch> findPageByConditions(@Param("page") Page<AuditMatch> page, @Param("dto") AuditMatchDto auditMatchDto);

    /**
     * 分页查询数据
     * @param page
     * @param auditMatchDto
     * @return
     */
    Page<AuditMatchVo> findAuditMatchVoPageByConditions(@Param("page") Page<AuditMatchVo> page, @Param("dto") AuditMatchDto auditMatchDto);
}

