package com.biz.crm.kms.business.audit.match.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.audit.match.local.entity.AuditSapEntity;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapConditionDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * 稽核Sap数据表mybatis访问层
 *
 * @author cyj
 * @since 2022-12-19 17:18:44
 */
public interface AuditSapMapper extends BaseMapper<AuditSapEntity> {

    /**
     * 根据条件分页查询Sap数据
     * @param page
     * @param transStatus
     * @return
     */
    Page<String> findSapPageByTransStatus(Page<AuditSapEntity> page, @Param("transStatus") String transStatus,@Param("tenantCode") String tenantCode);

    /**
     * 根据sap编码和物料查询数据
     * @param salesDeliveryNo
     * @param materialCode
     * @return
     */
    List<AuditSapVo> findBySalesDeliveryNoAndMaterialCode(@Param("salesDeliveryNo")String salesDeliveryNo, @Param("materialCode")String materialCode);

    /**
     * 根据校验字段查询数据
     * @param verifyCode
     * @return
     */
    List<AuditSapVo> findByVerifyCode(@Param("verifyCode")String verifyCode);
    void batchSave(@Param("list") Collection<AuditSapEntity> list);

    /**
     * 条件查询
     *
     * @param dto
     * @return
     */
    List<AuditSapEntity> findByCondition(@Param("dto") AuditSapConditionDto dto);

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param auditSapDto 查询实体
     * @return 所有数据
     */
    Page<AuditSapVo> findPageByConditions(@Param("page") Page<AuditSapVo> page, @Param("dto") AuditSapDto auditSapDto);

    /**
     * 批量保存数据
     *
     * @param saveList
     */
    void saveBatchData(@Param("saveList") Collection<AuditSapEntity> saveList);

    /**
     * 折扣率变量剩余费用池余额 统计
     *
     * @param dto 统计参数
     * @return List<SurplusFeePoolBalanceVo>
     */
    List<SurplusFeePoolBalanceAuditMatchVo> surplusFeePoolBalance(@Param("dto") SurplusFeePoolBalanceAuditMatchDto dto);
}

