package com.biz.crm.kms.business.audit.match.local.model;

import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 稽查匹配关联单据表model
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditMatchInvoiceModel", description = "稽查匹配关联单据表model")
public class AuditMatchInvoiceModel {

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 稽核单号
   */
  @ApiModelProperty("稽核单号")
  private String auditCode;

  /**
   * 单据类型
   *
   * @see InvoiceTypeRegister#type()
   */
  @ApiModelProperty("单据类型")
  private String invoiceType;

  /**
   * 单据唯一编码
   */
  @ApiModelProperty("单据唯一编码")
  private String invoiceCode;


  /**
   * 关系ID
   */
  @ApiModelProperty("关系ID")
  private String relationId;

  /**
   * 新单号
   */
  @ApiModelProperty("新单号")
  private String crossOrderNumber;
}
