package com.biz.crm.kms.business.audit.match.local.model;

import com.biz.crm.kms.business.audit.match.sdk.enums.PriceTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 稽查模板商超数据model
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditTemplateSupermarketModel", description = "稽查模板商超数据model")
public class AuditTemplateSupermarketModel {

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 商超系统名称
   */
  @ApiModelProperty("商超系统名称")
  private String supermarketName;

  /**
   * 价格容差类型 {@link PriceTypeEnum#getDictCode()}
   */
  @ApiModelProperty("价格容差类型")
  private String priceType;

  /**
   * 价格容差值
   */
  @ApiModelProperty("价格容差值")
  private BigDecimal priceValue;

  /**
   * 延迟收货天数
   */
  @ApiModelProperty("延迟收货天数")
  private Integer delayDays;

}
