package com.biz.crm.kms.business.audit.match.local.model;

import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchConsequence;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchCrossAcceptance;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchConsequenceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchCrossAcceptanceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchInvoiceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchRepository;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchConsequenceService;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchInvoiceService;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchNotReasonDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.AuditDifferTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchResultEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.PriceTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 匹配逻辑计算抽象类
 *
 * @author songjingen
 * @date 2022/10/25 15:42
 */
public abstract class MatchConsequenceCalculatedAbstract {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private AuditMatchConsequenceService auditMatchConsequenceService;
  @Autowired(required = false)
  private AuditMatchInvoiceService auditMatchInvoiceService;

  @Autowired(required = false)
  private AuditMatchConsequenceRepository auditMatchConsequenceRepository;

  @Autowired(required = false)
  private AuditMatchService auditMatchService;

  @Autowired(required = false)
  private AuditMatchCrossAcceptanceRepository auditMatchCrossAcceptanceRepository;

  /**
   * 1、this.covertMatchLogicCalculatedModels(auditTemplateSupermarketModels)进行数据转换； 2、获取单据的数据，并且进行赋值 ；3、this.calculate(matchLogicCalculatedModels)执行计算逻辑
   * @param templateCode 模板编码
   * @param models       匹配结果数据
   */
  public abstract void execute(String templateCode, List<MatchConsequenceCalculatedModel> models);

  /**
   * 1、this.covertMatchLogicCalculatedModels(auditTemplateSupermarketModels)进行数据转换； 2、获取单据的数据，并且进行赋值 ；3、this.calculate(matchLogicCalculatedModels)执行计算逻辑
   * @param auditTemplate 稽核模板
   * @param models       匹配结果数据
   */
  public abstract void executeAuto(AuditTemplate auditTemplate, List<MatchConsequenceCalculatedModel> models);

  /**
   * 1、this.covertMatchLogicCalculatedModels(auditTemplateSupermarketModels)进行数据转换； 2、获取单据的数据，并且进行赋值 ；3、this.calculate(matchLogicCalculatedModels)执行计算逻辑
   * @param auditMatchInvoices 稽核关联单据
   * @param templateCode 模板编码
   * @param model       匹配结果数据
   */
  public abstract void notAutoExecute(String templateCode, MatchConsequenceCalculatedModel model,List<AuditMatchInvoice> auditMatchInvoices);

  /**
   * 匹配逻辑计算执行操作，计算差异情况并且入库；所有的匹配逻辑执行都需要调用此方法； 1、查询模板对应的商超条件数据； 2、循环计算数据； 2.1、进行数量条件匹配 2.2、进行金额差异匹配
   *
   * @param calculatedModels 计算所需要的原始数据
   */
  @Transactional(rollbackFor = Exception.class)
  protected void calculate(List<MatchConsequenceCalculatedModel> calculatedModels, List<AuditMatchNotReasonDto> notReasonDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(calculatedModels), "匹配逻辑计算所需要的原始数据不存在！");
    List<AuditMatchConsequence> auditMatchConsequences = new ArrayList<>();
    List<AuditMatchInvoice> auditMatchInvoices = new ArrayList<>();
    List<String> auditCodes = new ArrayList<>();
    List<AuditMatchCrossAcceptance> updateCrossAuditCode = new ArrayList<>();
    for (MatchConsequenceCalculatedModel model : calculatedModels) {
      //1.1、判断匹配到单据，未匹配到则跳过，不予处理当前稽核数据
      List<AuditMatchInvoiceModel> auditMatchInvoiceModels = model.getAuditMatchInvoiceModels();
      if (CollectionUtils.isEmpty(auditMatchInvoiceModels)) {
        continue;
      }
      auditCodes.add(model.getAuditCode());
      //1.2、存在则转换成保存数据格式，并添加到保存集合中
      List<AuditMatchInvoice> matchInvoices = (List<AuditMatchInvoice>) this.nebulaToolkitService.copyCollectionByWhiteList(auditMatchInvoiceModels, AuditMatchInvoiceModel.class,
          AuditMatchInvoice.class, HashSet.class, ArrayList.class);
      auditMatchInvoices.addAll(matchInvoices);
      //2.1、计算数量，并且标记是否有差异
      boolean quantityVarianceFlag = false;
      BigDecimal quantityVariance = model.getSapEaCount().subtract(model.getInvoiceTotalCount());
      if (quantityVariance.compareTo(BigDecimal.ZERO) == 0) {
        quantityVarianceFlag = true;
      }
      //2.2、计算金额
      String priceType = model.getPriceType();
      BigDecimal priceValue = model.getPriceValue();
      BigDecimal amountVariance = BigDecimal.ZERO;
      boolean amountVarianceFlag = false;
      BigDecimal erpTotalAmount = model.getSapTotalAmount();
      BigDecimal invoiceTotalAmount = model.getInvoiceTotalAmount();
      if (StringUtils.isNotBlank(priceType) && priceValue != null) {
        switch (PriceTypeEnum.getByDictCode(priceType)) {
          case Z:
            amountVariance = erpTotalAmount.subtract(invoiceTotalAmount);
            if (amountVariance.compareTo(BigDecimal.ZERO) >= 0 && amountVariance.compareTo(priceValue) <= 0) {
              amountVarianceFlag = true;
              amountVariance = amountVariance.abs();
            }
            break;
          case F:
            amountVariance = erpTotalAmount.subtract(invoiceTotalAmount);
            if (amountVariance.compareTo(BigDecimal.ZERO) <= 0) {
              amountVariance = amountVariance.abs();
              if (amountVariance.compareTo(priceValue) <= 0) {
                amountVarianceFlag = true;
              }
            }
            break;
          case UD:
            amountVariance = invoiceTotalAmount.subtract(erpTotalAmount).abs();
            if (amountVariance.compareTo(priceValue) <= 0) {
              amountVarianceFlag = true;
            }
            break;
          default:
            break;
        }
      } else {
        amountVariance = erpTotalAmount.subtract(invoiceTotalAmount);
        if (amountVariance.compareTo(BigDecimal.ZERO) == 0) {
          amountVarianceFlag = true;
        }
      }
      //2.3、计算金额（不含税）
      boolean amountVarianceTaxExclusiveFlag = false;
      BigDecimal amountVarianceTaxExclusive = BigDecimal.ZERO;
      if (StringUtils.isNotBlank(priceType) && priceValue != null) {
        switch (PriceTypeEnum.getByDictCode(priceType)) {
          case Z:
            amountVarianceTaxExclusive = model.getSapTotalAmountTaxExclusive().subtract(model.getInvoiceTotalAmountTaxExclusive());
            if (amountVarianceTaxExclusive.compareTo(BigDecimal.ZERO) >= 0 || amountVarianceTaxExclusive.compareTo(priceValue) <= 0) {
              amountVarianceTaxExclusiveFlag = true;
              amountVarianceTaxExclusive = amountVarianceTaxExclusive.abs();
            }
            break;
          case F:
            amountVarianceTaxExclusive = model.getSapTotalAmountTaxExclusive().subtract(model.getInvoiceTotalAmountTaxExclusive());
            if (amountVariance.compareTo(BigDecimal.ZERO) <= 0) {
              amountVarianceTaxExclusive = amountVarianceTaxExclusive.abs();
              if (amountVarianceTaxExclusive.compareTo(priceValue) <= 0) {
                amountVarianceTaxExclusiveFlag = true;
              }
            }
            break;
          case UD:
            amountVarianceTaxExclusive = model.getSapTotalAmountTaxExclusive().subtract(model.getInvoiceTotalAmountTaxExclusive());
            if (amountVarianceTaxExclusive.compareTo(priceValue) <= 0) {
              amountVarianceTaxExclusiveFlag = true;
            }
            break;
          default:
            break;
        }
      } else {
        amountVarianceTaxExclusive = model.getSapTotalAmountTaxExclusive().subtract(model.getInvoiceTotalAmountTaxExclusive());
        if (amountVarianceTaxExclusive.compareTo(BigDecimal.ZERO) == 0) {
          amountVarianceTaxExclusiveFlag = true;
        }
      }
      //2.4、转成成保存数据并且赋值，添加到保存集合中
      AuditMatchConsequence consequence = this.nebulaToolkitService.copyObjectByWhiteList(model, AuditMatchConsequence.class,
          HashSet.class, ArrayList.class);
      if (amountVarianceFlag) {
        consequence.setMatchConsequence(MatchResultEnum.NO.getDictCode());
      }else {
        consequence.setMatchConsequence(MatchResultEnum.YES.getDictCode());
      }
      //2.5、计算单价差异
      if (model.getInvoicePrice() != null && model.getSapPrice() != null){
        BigDecimal priceVariance = BigDecimal.ZERO;
        priceVariance = model.getSapPrice().subtract(model.getInvoicePrice()).abs();
        consequence.setInvoicePrice(model.getInvoicePrice());
        consequence.setInvoicePriceNoTax(model.getInvoicePriceNoTax());
        consequence.setAmountVariancePrice(priceVariance);
      }
      consequence.setQuantityVariance(quantityVariance.abs());
      consequence.setAmountVariance(amountVariance);
      consequence.setAmountVarianceTaxExclusive(amountVarianceTaxExclusive);
      consequence.setVerifyCode(model.getVerifyCode());
      //2.6、差异类型
      if (BigDecimal.ZERO.compareTo(consequence.getQuantityVariance()) != 0 && BigDecimal.ZERO.compareTo(consequence.getAmountVariancePrice()) == 0){
        consequence.setDifferType(AuditDifferTypeEnum.QUANTITY.getDictCode());
      }else if (BigDecimal.ZERO.compareTo(consequence.getQuantityVariance()) == 0 && BigDecimal.ZERO.compareTo(consequence.getAmountVariancePrice()) != 0){
        consequence.setDifferType(AuditDifferTypeEnum.AMOUNT.getDictCode());
      }else if (BigDecimal.ZERO.compareTo(consequence.getQuantityVariance()) != 0 && BigDecimal.ZERO.compareTo(consequence.getAmountVariancePrice()) != 0){
        consequence.setDifferType(AuditDifferTypeEnum.QUANTITYANDAMOUNT.getDictCode());
      }
      //2.7、窜单匹配回写集合单号
      String crossOrderNumber = model.getCrossOrderNumber();
      if (StringUtils.isNotEmpty(crossOrderNumber)){
          AuditMatchCrossAcceptance auditMatchCrossAcceptance = new AuditMatchCrossAcceptance();
          auditMatchCrossAcceptance.setAuditCode(model.getAuditCode());
          auditMatchCrossAcceptance.setVerifyCode(model.getVerifyCode());
          updateCrossAuditCode.add(auditMatchCrossAcceptance);
      }
      auditMatchConsequences.add(consequence);
    }
    //3、保存
    //删除已经匹配过的逻辑
    if (!CollectionUtils.isEmpty(auditMatchConsequences)) {
      if (!CollectionUtils.isEmpty(auditCodes)) {
        if (!CollectionUtils.isEmpty(auditMatchInvoices)) {
//          this.auditMatchConsequenceRepository.deleteByAuditCodes(auditCodes);
          this.auditMatchConsequenceService.createOrUpdateBatch(auditMatchConsequences);
          this.auditMatchInvoiceService.createBatch(auditMatchInvoices);
          if (!CollectionUtils.isEmpty(updateCrossAuditCode)){
            this.auditMatchCrossAcceptanceRepository.updateAuditCrossAcceptanceByVerifyCodes(updateCrossAuditCode);
          }
        }
      }
    }
    if (!CollectionUtils.isEmpty(notReasonDtos)){
      this.auditMatchService.updateNotMatchReason(notReasonDtos);
    }
  }


  @Transactional(rollbackFor = Exception.class)
  protected void manuCalculate(MatchConsequenceCalculatedModel calculatedModel, List<String> ids) {
    Validate.isTrue(!Objects.isNull(calculatedModel), "匹配逻辑计算所需要的原始数据不存在！");
    List<AuditMatchConsequence> auditMatchConsequences = new ArrayList<>();
    List<AuditMatchInvoice> auditMatchInvoices = new ArrayList<>();
    List<String> auditCodes = new ArrayList<>();
    //1、判断匹配到单据，未匹配到则跳过，不予处理当前稽核数据
    List<AuditMatchInvoiceModel> auditMatchInvoiceModels = calculatedModel.getAuditMatchInvoiceModels();
    if (CollectionUtils.isEmpty(auditMatchInvoiceModels)) {
      return;
    }
    auditCodes.add(calculatedModel.getAuditCode());
    //1.2、存在则转换成保存数据格式，并添加到保存集合中
    List<AuditMatchInvoice> matchInvoices = (List<AuditMatchInvoice>) this.nebulaToolkitService.copyCollectionByWhiteList(auditMatchInvoiceModels, AuditMatchInvoiceModel.class,
            AuditMatchInvoice.class, HashSet.class, ArrayList.class);
    auditMatchInvoices.addAll(matchInvoices);
    //2.1、计算数量，并且标记是否有差异
    boolean quantityVarianceFlag = false;
    BigDecimal quantityVariance = calculatedModel.getSapEaCount().subtract(calculatedModel.getInvoiceTotalCount());
    if (quantityVariance.compareTo(BigDecimal.ZERO) == 0) {
      quantityVarianceFlag = true;
    }
    //2.2、计算金额
    String priceType = calculatedModel.getPriceType();
    BigDecimal priceValue = calculatedModel.getPriceValue();
    BigDecimal amountVariance = BigDecimal.ZERO;
    boolean amountVarianceFlag = false;
    BigDecimal erpTotalAmount = calculatedModel.getSapTotalAmount();
    BigDecimal invoiceTotalAmount = calculatedModel.getInvoiceTotalAmount();
    if (StringUtils.isNotBlank(priceType) && priceValue != null) {
      switch (PriceTypeEnum.getByDictCode(priceType)) {
        case Z:
          amountVariance = erpTotalAmount.subtract(invoiceTotalAmount);
          if (amountVariance.compareTo(BigDecimal.ZERO) >= 0 && amountVariance.compareTo(priceValue) <= 0) {
            amountVarianceFlag = true;
            amountVariance = amountVariance.abs();
          }
          break;
        case F:
          amountVariance = erpTotalAmount.subtract(invoiceTotalAmount);
          if (amountVariance.compareTo(BigDecimal.ZERO) <= 0) {
            amountVariance = amountVariance.abs();
            if (amountVariance.compareTo(priceValue) <= 0) {
              amountVarianceFlag = true;
            }
          }
          break;
        case UD:
          amountVariance = invoiceTotalAmount.subtract(erpTotalAmount).abs();
          if (amountVariance.compareTo(priceValue) <= 0) {
            amountVarianceFlag = true;
          }
          break;
        default:
          break;
      }
    } else {
      amountVariance = erpTotalAmount.subtract(invoiceTotalAmount);
      if (amountVariance.compareTo(BigDecimal.ZERO) == 0) {
        amountVarianceFlag = true;
      }
    }
    //2.3、计算金额（不含税）
    boolean amountVarianceTaxExclusiveFlag = false;
    BigDecimal amountVarianceTaxExclusive = BigDecimal.ZERO;
    if (StringUtils.isNotBlank(priceType) && priceValue != null) {
      switch (PriceTypeEnum.getByDictCode(priceType)) {
        case Z:
          amountVarianceTaxExclusive = calculatedModel.getSapTotalAmountTaxExclusive().subtract(calculatedModel.getInvoiceTotalAmountTaxExclusive());
          if (amountVarianceTaxExclusive.compareTo(BigDecimal.ZERO) >= 0 || amountVarianceTaxExclusive.compareTo(priceValue) <= 0) {
            amountVarianceTaxExclusiveFlag = true;
            amountVarianceTaxExclusive = amountVarianceTaxExclusive.abs();
          }
          break;
        case F:
          amountVarianceTaxExclusive = calculatedModel.getSapTotalAmountTaxExclusive().subtract(calculatedModel.getInvoiceTotalAmountTaxExclusive());
          if (amountVariance.compareTo(BigDecimal.ZERO) <= 0) {
            amountVarianceTaxExclusive = amountVarianceTaxExclusive.abs();
            if (amountVarianceTaxExclusive.compareTo(priceValue) <= 0) {
              amountVarianceTaxExclusiveFlag = true;
            }
          }
          break;
        case UD:
          amountVarianceTaxExclusive = calculatedModel.getSapTotalAmountTaxExclusive().subtract(calculatedModel.getInvoiceTotalAmountTaxExclusive());
          if (amountVarianceTaxExclusive.compareTo(priceValue) <= 0) {
            amountVarianceTaxExclusiveFlag = true;
          }
          break;
        default:
          break;
      }
    } else {
      amountVarianceTaxExclusive = calculatedModel.getSapTotalAmountTaxExclusive().subtract(calculatedModel.getInvoiceTotalAmountTaxExclusive());
      if (amountVarianceTaxExclusive.compareTo(BigDecimal.ZERO) == 0) {
        amountVarianceTaxExclusiveFlag = true;
      }
    }
    //2.4、转成成保存数据并且赋值，添加到保存集合中
    AuditMatchConsequence consequence = this.nebulaToolkitService.copyObjectByWhiteList(calculatedModel, AuditMatchConsequence.class,
            HashSet.class, ArrayList.class);
    if (amountVarianceFlag) {
      consequence.setMatchConsequence(MatchResultEnum.NO.getDictCode());
    }else {
      consequence.setMatchConsequence(MatchResultEnum.YES.getDictCode());
    }
    if (calculatedModel.getInvoicePrice() != null && calculatedModel.getSapPrice() != null){
      BigDecimal priceVariance = BigDecimal.ZERO;
      priceVariance = calculatedModel.getSapPrice().subtract(calculatedModel.getInvoicePrice()).abs();
      consequence.setInvoicePrice(calculatedModel.getInvoicePrice());
      consequence.setAmountVariancePrice(priceVariance);
      consequence.setInvoicePriceNoTax(calculatedModel.getInvoicePriceNoTax());
    }
    consequence.setQuantityVariance(quantityVariance.abs());
    consequence.setAmountVariance(amountVariance);
    consequence.setAmountVarianceTaxExclusive(amountVarianceTaxExclusive);
    //2.6、差异类型
    if (BigDecimal.ZERO.compareTo(consequence.getQuantityVariance()) != 0 && BigDecimal.ZERO.compareTo(consequence.getAmountVariancePrice()) == 0){
      consequence.setDifferType(AuditDifferTypeEnum.QUANTITY.getDictCode());
    }else if (BigDecimal.ZERO.compareTo(consequence.getQuantityVariance()) == 0 && BigDecimal.ZERO.compareTo(consequence.getAmountVariancePrice()) != 0){
      consequence.setDifferType(AuditDifferTypeEnum.AMOUNT.getDictCode());
    }else if (BigDecimal.ZERO.compareTo(consequence.getQuantityVariance()) != 0 && BigDecimal.ZERO.compareTo(consequence.getAmountVariancePrice()) != 0){
      consequence.setDifferType(AuditDifferTypeEnum.QUANTITYANDAMOUNT.getDictCode());
    }
    auditMatchConsequences.add(consequence);
    //3、保存
    //删除已经匹配过的逻辑
    if (!CollectionUtils.isEmpty(auditMatchConsequences)) {
      if (!CollectionUtils.isEmpty(auditCodes)) {
        if (!CollectionUtils.isEmpty(auditMatchInvoices)) {
          this.auditMatchConsequenceRepository.deleteByAuditCodes(auditCodes);
          this.auditMatchConsequenceService.createOrUpdateBatch(auditMatchConsequences);
          this.auditMatchInvoiceService.createBatchManu(ids, auditCodes.get(0));
        }
      }
    }
  }
}
