package com.biz.crm.kms.business.audit.match.local.model;

import com.biz.crm.kms.business.audit.match.sdk.enums.PriceTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;

/**
 * 匹配逻辑计算model
 *
 * @author songjingen
 * @date 2022/10/25 15:44
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MatchLogicCalculatedModel", description = "匹配逻辑计算model")
public class MatchConsequenceCalculatedModel extends MatchParamModel {

  /**
   * 稽核结果id
   */
  @ApiModelProperty("id")
  private String id;

  /**
   * 稽核单号
   */
  @ApiModelProperty("稽核单号")
  private String auditCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 稽核模板
   */
  @ApiModelProperty("稽核模板")
  private String templateCode;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String kaCode;

  /**
   * SAP单数量（EA）
   */
  @ApiModelProperty("SAP单数量（EA）")
  private BigDecimal sapEaCount;

  /**
   * 单据总数量
   */
  @ApiModelProperty("单据总数量")
  private BigDecimal invoiceTotalCount;

  /**
   * SAP单价
   */
  @ApiModelProperty("SAP单价")
  private BigDecimal sapPrice;

  /**
   * 单据单价
   */
  @ApiModelProperty("单据单价")
  private BigDecimal invoicePrice;

  /**
   * 单据未税单价
   */
  @ApiModelProperty("单据未税单价")
  private BigDecimal invoicePriceNoTax;

  /**
   * SAP总金额
   */
  @ApiModelProperty("SAP总金额")
  private BigDecimal sapTotalAmount;

  /**
   * sap总金额（不含税）
   */
  @ApiModelProperty("sap总金额（不含税）")
  private BigDecimal sapTotalAmountTaxExclusive;

  /**
   * 单据总金额
   */
  @ApiModelProperty("单据总金额")
  private BigDecimal invoiceTotalAmount;

  /**
   * 单据总金额（不含税）
   */
  @ApiModelProperty("单据总金额（不含税）")
  private BigDecimal invoiceTotalAmountTaxExclusive;

  /**
   * 价格容差类型 {@link PriceTypeEnum#getDictCode()}
   */
  @ApiModelProperty("价格容差类型")
  private String priceType;

  /**
   * 价格容差值
   */
  @ApiModelProperty("价格容差值")
  private BigDecimal priceValue;

  /**
   * 时间容差类型
   */
  @ApiModelProperty("时间容差类型")
  private String delayType;

  /**
   * 时间容差值
   */
  @ApiModelProperty("时间容差值")
  private Integer delayDays;

  /**
   * 匹配单据集合
   */
  @ApiModelProperty("匹配单据集合")
  private List<AuditMatchInvoiceModel> auditMatchInvoiceModels;

  /**
   * 未匹配原因
   */
  @ApiModelProperty("未匹配原因")
  private String notMatchReason;

  /**
   * 校验单号
   */
  @ApiModelProperty("校验单号")
  private String verifyCode;

  /**
   * 新单号
   */
  @ApiModelProperty("新单号")
  private String crossOrderNumber;
}
