package com.biz.crm.kms.business.audit.match.local.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 匹配条件model
 *
 * @author songjingen
 * @date 2022/10/25 15:44
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MatchParamModel", description = "匹配条件model")
public class MatchParamModel {

  /**
   * ERP物料号
   */
  @ApiModelProperty("SAP物料号")
  private String sapMaterialCode;

  /**
   * SAP过账日期
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date sapPostingDate;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String deliveryCode;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 关联订单号
   */
  @ApiModelProperty("关联订单号")
  private String relationOrderCode;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  private String templateCode;


}
