package com.biz.crm.kms.business.audit.match.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchConsequence;
import com.biz.crm.kms.business.audit.match.local.mapper.AuditMatchConsequenceMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 稽查匹配结果表(AuditMatchConsequence)表数据库访问层
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
@Component
public class AuditMatchConsequenceRepository extends ServiceImpl<AuditMatchConsequenceMapper, AuditMatchConsequence> {

  /**
   * 通过稽核单号集合查询数据
   *
   * @param auditCodes 稽核单号稽核
   * @return 结果集
   */
  public List<AuditMatchConsequence> findByAuditCodes(List<String> auditCodes) {
    return this.lambdaQuery().eq(AuditMatchConsequence::getTenantCode, TenantUtils.getTenantCode())
        .in(AuditMatchConsequence::getAuditCode, auditCodes)
        .list();
  }

  /**
   * 根据稽核单号删除已匹配的结果
   *
   * @param auditCodes
   */
  public void deleteByAuditCodes(List<String> auditCodes) {
    if (CollectionUtils.isNotEmpty(auditCodes)) {
      this.lambdaUpdate().in(AuditMatchConsequence::getAuditCode, auditCodes)
              .eq(AuditMatchConsequence::getTenantCode, TenantUtils.getTenantCode())
              .remove();
    }
  }
}

