package com.biz.crm.kms.business.audit.match.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchCrossAcceptance;
import com.biz.crm.kms.business.audit.match.local.mapper.AuditMatchCrossAcceptanceMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/3/13 14:38
 * @description AuditMatchCrossAcceptanceRepository
 */
@Component
public class AuditMatchCrossAcceptanceRepository extends ServiceImpl<AuditMatchCrossAcceptanceMapper, AuditMatchCrossAcceptance> {

    /**
     * 根据校验单号查询窜单数据
     * @param verifyCodes
     * @param tenantCode
     * @return
     */
    public List<AuditMatchCrossAcceptance> findAuditCrossAcceptanceByVerifyCodes(List<String> verifyCodes,String tenantCode){
        if (CollectionUtils.isEmpty(verifyCodes)){
            return Lists.newArrayList();
        }else {
            return this.lambdaQuery().eq(AuditMatchCrossAcceptance::getTenantCode,tenantCode).in(AuditMatchCrossAcceptance::getVerifyCode,verifyCodes).list();
        }
    }

    /**
     * 更新稽核单号
     * @param auditMatchCrossAcceptances
     */
    public void updateAuditCrossAcceptanceByVerifyCodes(List<AuditMatchCrossAcceptance> auditMatchCrossAcceptances){
        if (CollectionUtils.isNotEmpty(auditMatchCrossAcceptances)){
            for (AuditMatchCrossAcceptance auditMatchCrossAcceptance : auditMatchCrossAcceptances) {
                this.lambdaUpdate().eq(AuditMatchCrossAcceptance::getTenantCode, TenantUtils.getTenantCode()).eq(AuditMatchCrossAcceptance::getVerifyCode,auditMatchCrossAcceptance.getVerifyCode()).set(AuditMatchCrossAcceptance::getAuditCode,auditMatchCrossAcceptance.getAuditCode()).update();
            }
        }
    }
}
