package com.biz.crm.kms.business.audit.match.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.mapper.AuditTemplateMapper;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditTemplateTabVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 稽查模板表(AuditTemplate)表数据库访问层
 *
 * @author songjingen
 * @since 2022-10-13 14:40:29
 */
@Component
public class AuditTemplateRepository extends ServiceImpl<AuditTemplateMapper, AuditTemplate> {

  @Autowired
  private AuditTemplateMapper auditTemplateMapper;

  /**
   * 根据id集合查询数据
   *
   * @param idList id集合
   * @return
   */
  public List<AuditTemplate> findByIds(List<String> idList) {
    return this.lambdaQuery().eq(AuditTemplate::getTenantCode, TenantUtils.getTenantCode())
        .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(AuditTemplate::getId, idList)
        .list();
  }

  /**
   * 根据id集合和启禁用状态查询数据
   *
   * @param statusEnum 启禁用状态
   * @param idList     id集合
   * @return
   */
  public List<AuditTemplate> findByEnableStatusAndIds(EnableStatusEnum statusEnum, List<String> idList) {
    return this.lambdaQuery().eq(AuditTemplate::getTenantCode, TenantUtils.getTenantCode())
        .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditTemplate::getEnableStatus, statusEnum.getCode())
        .in(AuditTemplate::getId, idList)
        .list();
  }

  /**
   * 稽核匹配时间查询数据集合
   *
   * @param matchTime
   * @return 数据集合
   */
  public List<AuditTemplate> findByMatchTime(String matchTime) {
    return this.lambdaQuery().eq(AuditTemplate::getTenantCode, TenantUtils.getTenantCode())
        .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditTemplate::getMatchTime, matchTime)
        .list();
  }

  /**
   * 根据模板编码查询对象
   *
   * @param templateCode 模板编码
   * @return 单条数据
   */
  public AuditTemplate findByTemplateCode(String templateCode) {
    return this.lambdaQuery().eq(AuditTemplate::getTenantCode, TenantUtils.getTenantCode())
        .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditTemplate::getEnableStatus,DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditTemplate::getTemplateCode, templateCode)
        .one();
  }

  /**
   * 根据模板编码集合查询对象
   * @param templateCodes
   * @return
   */
  public List<AuditTemplate> findByTemplateCodes(List<String> templateCodes) {
    return this.lambdaQuery().eq(AuditTemplate::getTenantCode, TenantUtils.getTenantCode())
            .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditTemplate::getEnableStatus,DelFlagStatusEnum.NORMAL.getCode())
            .in(AuditTemplate::getTemplateCode, templateCodes)
            .list();
  }


  /**
   * 查询全部模板对象
   */
  public List<AuditTemplate> listAuditTemplate() {
    return this.lambdaQuery()
            .eq(AuditTemplate::getEnableStatus,DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .list();
  }

  /**
   * 根据模板名称查询数据
   *
   * @param templateName 模板名称
   * @return
   */
  public List<AuditTemplate> findByTemplateName(String templateName) {
    return this.lambdaQuery().eq(AuditTemplate::getTenantCode, TenantUtils.getTenantCode())
        .eq(AuditTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(AuditTemplate::getTemplateName, templateName)
        .list();
  }

  /**
   * 根据模板名称查询tab栏
   * @param templateName
   * @return
   */
  public List<AuditTemplateTabVo> findByTemplateNameTab(String templateName){
    return this.auditTemplateMapper.findByTemplateNameTab(templateName,TenantUtils.getTenantCode());
  }
}

