package com.biz.crm.kms.business.audit.match.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.mapper.AuditTemplateSupermarketMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 稽查模板商超数据表(AuditTemplateSupermarket)表数据库访问层
 *
 * @author songjingen
 * @since 2022-10-13 14:40:32
 */
@Component
public class AuditTemplateSupermarketRepository extends ServiceImpl<AuditTemplateSupermarketMapper, AuditTemplateSupermarket> {

  /**
   * 根据模板编码集合删除数据
   *
   * @param templateCodes 模板编码集合
   */
  public void deleteByTemplateCodes(List<String> templateCodes) {
    this.lambdaUpdate().in(AuditTemplateSupermarket::getTemplateCode, templateCodes).remove();
  }

  /**
   * 根据模板编码查询商超数据集合
   *
   * @param templateCodes 模板编码集合
   * @return
   */
  public List<AuditTemplateSupermarket> findByTemplateCodes(List<String> templateCodes) {
    return this.lambdaQuery().in(AuditTemplateSupermarket::getTemplateCode, templateCodes).list();
  }

  /**
   * 根据模板编码和系统编码稽核查询商超数据集合
   *
   * @param templateCode 模板编码
   * @param directCodes  系统编码集合
   * @return
   */
  public List<AuditTemplateSupermarket> findByTemplateCodeAndDirectCodes(String templateCode, List<String> directCodes) {
    return this.lambdaQuery()
        .eq(AuditTemplateSupermarket::getTemplateCode, templateCode)
        .in(AuditTemplateSupermarket::getDirectCode, directCodes)
        .list();
  }

  /**
   * 根据系统编码查询商超数据
   * @param directCode
   * @return
   */
  public List<AuditTemplateSupermarket> findByDirectCode(String directCode) {
    return this.lambdaQuery()
            .eq(AuditTemplateSupermarket::getDirectCode, directCode)
            .list();
  }

  /**
   * 根据系统编码稽核查询商超数据
   * @param directCodes
   * @return
   */
  public List<AuditTemplateSupermarket> findByDirectCodes(List<String> directCodes){
    return this.lambdaQuery()
            .in(AuditTemplateSupermarket::getDirectCode, directCodes)
            .list();
  }
}

