package com.biz.crm.kms.business.audit.match.local.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.audit.match.local.entity.KmsAuditSummary;
import com.biz.crm.kms.business.audit.match.local.mapper.KmsAuditSummaryMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 * 稽核汇总表(KmsAuditSummary)表数据库访问层
 *
 * @author cyj
 * @since 2023-01-04 14:44:50
 */
@Component
public class KmsAuditSummaryRepository extends ServiceImpl<KmsAuditSummaryMapper, KmsAuditSummary> {

    @Autowired(required = false)
    private KmsAuditSummaryMapper kmsAuditSummaryMapper;

    /**
     * 分页查询数据
     *
     * @param pageable        分页对象
     * @param kmsAuditSummary 实体对象
     * @return
     */
    public Page<KmsAuditSummary> findByConditions(Pageable pageable, KmsAuditSummary kmsAuditSummary) {
        Page<KmsAuditSummary> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<KmsAuditSummary> pageList = this.kmsAuditSummaryMapper.findByConditions(page, kmsAuditSummary);
        return pageList;
    }

    public void deleteByIds(List<String> ids){
        if (!CollectionUtils.isEmpty(ids)){
            this.lambdaUpdate().in(KmsAuditSummary::getId,ids).eq(KmsAuditSummary::getTenantCode, TenantUtils.getTenantCode()).set(KmsAuditSummary::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
        }else {
            return;
        }
    }
}

